function [ e ] = cv(n,X,t,M,lambda)
%cv does n-fold cross validation to estimate the rmse for a given lambda

N = size(X,1);
s = floor(N/n);

e = 0;
for i=1:n
   %building the cv datasets
   I1 = 1:( (i-1)*s );
   J = ((i-1)*s + 1):(i*s);
   I2 = (i*s + 1):N;

   Xd = [X(I1,:);X(I2,:)];
   td = [t(I1);t(I2)];
   Xe = X(J);
   te = t(J);
   
   w = ridge_regression(Xd,td,M,lambda);
   e = e + rmse(w,Xe,te); 
end
e = e/n;    

end

