clear all;
load('nonlinearData.mat');

n=10;
M=12;
loglambdavals = -25:0.01:-5;

k = length(loglambdavals);
e = zeros(k,1);

tt = tic;
for i=1:k
   e(i) = cv(n,X,t,M,exp(loglambdavals(i)));
end
time = toc(tt);
disp(time);

figure, plot(loglambdavals,e);

[~,I] = min(e);
lambda = exp(loglambdavals(I));
wrr = ridge_regression(X,t,M,lambda);
x = [0:0.01:1]';
y = polyE(x,wrr);
f = @(x)(sin(2*pi*x).^2 - cos(-2*pi*x));
figure, plot(X,t,'.',x,y,'r-',x,f(x),'g--');



