function [ wml ] = ridge_regression(X,t,M,lambda)
%ridge_regression Computes the regularised ML solution
% for a 1d poly model of degree M

N = size(X,1);
phi = zeros(N,M+1);
for i=1:N
    phi(i,:) = poly(X(i),M);
end
    wml = (diag(lambda*ones(M+1,1))+phi'*phi)\phi'*t;
    
end

