function [ w,i ] = perceptron( X,t,basis )
%Perceptron 

n = size(basis(X(1,:)),2);
N = size(X,1);
imax = 1000*N;
eta = 1;

Phi = zeros(N,n);
for i=1:N
   Phi(i,:) = basis(X(i,:)); 
end

w = -1 + 2*rand(n,1); %randomly init w
i=0;

P = Phi*w.*t<0;
M = sum(P);
while (M>0 && i<imax)
    j = 1 + mod(i,N);
    if P(j) 
        w = w + eta * Phi(j,:)'*t(j);
        P = Phi*w.*t<0;
        M = sum(P);
    end
    i = i+1;
end


end

