clear all;
load('nonlinearClassificationData.mat');
t(t==0) = -1;

basis = @(X)([1,X(1),X(2),X(1)^2,X(2)^2,X(1)*X(2)]);
[w,step] = perceptron(X,t,basis);


%plot using the symbolic toolbox
syms x y;
b = [1,x,y,x^2,y^2,x*y];
i1 = (t==1); i0 = (t==-1); 
figure, plot(X(i0,1),X(i0,2),'rx',X(i1,1),X(i1,2),'bx');
hold on;
ezplot(b*w==0,[-10,10,-10,10]);