#! /bin/bash

# Questo script,oltre a visualizzare tutte le 
# sottodirectory,  calcola la dimensione totale dei file regolari contenuti in esse


homedir=$(ls -d ~)								# Percorso propria directory (home).
echo "Trova tutte le sottodirectory (non nascoste) di $homedir"
echo
ls $homedir -R | grep "/*/" | tr ":" " "

	# Cerca in modo ricorsivo tutte le directory e sottodirectory non nascoste della home e stampa la dimensione totale dei file contenuti in esse.
	# Se si vuole copiare l'elenco su un file, basta togliere il # . Il file verrà creato nella directory in cui si trova 
	# lo script al momento dell'esecuzione (l'utente che esegue lo script deve avere i diritti di scrittura nella suddetta cartella).

bytes=$(ls $homedir -sR | grep "total" | cut -d' '  -f2-2)         		# Cerca in modo ricorsivo la dimensione dei file (KB) e li mette in "bytes"

declare -a arr									# separati da uno spazio.
arr=$(echo $bytes | tr ' ' ';')							# Sostituisce allo spazio il separatore ';'.
IFS=';'
bar=( $arr )									# Sposta il contenuto in un array.
elementi=${#bar[@]}								# Conta il numero di elementi dell'array.
n=0
declare -i somma=0
while ((  $n < $elementi )); do							# Somma tutte le dimensioni dei file presenti nell'array.
	somma=$(($somma + ${bar[n]}))
	n=$n+1
done
echo
if (( $somma >= 1024 ));then							# Definisce l'entità della dimensione totale dei file (KB, MB, GB, TB)
	somma=$somma/1024							# e stampa a schermo il risultato.
	if (( $somma >= 1024 ));then
		somma=$somma/1024
		if (( $somma >= 1024 ));then
			somma=$somma/1024
			if (( $somma >= 1024 ));then
				somma=$somma/1024
			else
			echo "Dimensione totale dei file: $somma TB"
			fi
		else
		echo "Dimensione totale dei file: $somma GB"
		fi
	else
	echo "Dimensione totale dei file: $somma MB"
	fi
else
echo "Dimensione totale dei file: $somma KB"
fi
exit 										# Uscita script.
