#! /bin/bash

# Questo script funziona come cat: viene attivato dando come parametro il 
# nome di un file e ne scrive il contenuto sullo standard output. La differenza e' che le parole 
# scritte sono alternativamente scritte con caratteri minuscoli e maiuscoli.


dircorr=$(pwd)									# Percorso assoluto directory corrente (cartella dove si trova lo script).
filename=$1

dircompl=$dircorr/$filename							# Percorso assoluto più nome file passato come parametro.
if [[ -e "$dircompl" ]]; then							# Controlla se il file inserito esiste.	
	declare -a arr			
	IFS=''					
	arr=$(cat "$dircompl") 							# Mette parole del file selezionato in un array.
	e=$(echo $arr | tr "\n" "|" | sed "s/|/ |/g")				# ATTENZIONE: nel testo non deve essere presente il carattere "|".
	IFS=' '
	bar=( $e )								
	elementi=${#bar[@]}							# Conta il numero di parole presenti nell'array.
	n=0
	p=0
	while [ $n -lt $elementi ]; do						
		r=$(($n%2))							# Se la parola si trova in una posizione pari dell'array
		provv=${bar[$n]}						# verrà stampata minuscola, altrimenti verrà stampata maiuscola.
		if [ $r -eq $p ];then
			provv=$(echo $provv | tr "[:upper:]" "[:lower:]")
		else
			provv=$(echo $provv | tr "[:lower:]" "[:upper:]")
		fi	
		bar[$n]=$provv
		let n=n+1
	done
	e=$(echo ${bar[@]} | tr "|" "\n") 
	bar=( $e )	
	echo		
	echo ${bar[@]}								# Stampa sul terminale lo standard output modificato
	echo
else
	echo
	echo "cat: $filename: Nessun file o directory"
	echo
fi
exit 										# Uscita script.
