#!/bin/bash

USAGE="myps.ksh, stampa una lista di processi in esecuzione nella forma 
nome-PID-PPID-time, visualizzando quelli con PID e PPID massimo e minimo, 
oltre ai processi in esecuzione che appartengono ad un certo utente 
specificato da tastiera"

#####################################
echo " Processo con PID massimo.."
#####################################
echo " NOME - PID - PPID - TIME "

# l'opzione '-le' in 'ps' visualizza tutti i processi (-e)
# e tutti i campi (-l)

ps -le | sort -k 4rn | head -1 | cut -c67-90 > nome.tmp
ps -le | sort -k 4rn | head -1 | cut -c10-15 > pid.tmp
ps -le | sort -k 4rn | head -1 | cut -c18-23 > pidd.tmp
ps -le | sort -k 4rn | head -1 | cut -c58-65 > time.tmp
paste nome.tmp pid.tmp pidd.tmp time.tmp
rm *.tmp

# l'opzione 'r' in 'sort' produce un ordinamento in ordine 
#decrescente rispetto al campo scelto
####################################
echo " Processo con PID minimo.."
####################################
echo " NOME - PID - PPID - TIME "

# "tail -2| head -1" serve ad eliminare la riga di testo
# che compare come ultima riga del file (si vuole estrarre la penultima)

ps -le | sort -k 4rn | tail -2 | head -1 | cut -c67-90 > nome.tmp
ps -le | sort -k 4rn | tail -2 | head -1 | cut -c10-15 > pid.tmp
ps -le | sort -k 4rn | tail -2 | head -1 | cut -c18-23 > pidd.tmp
ps -le | sort -k 4rn | tail -2 | head -1 | cut -c58-65 > time.tmp
paste nome.tmp pid.tmp pidd.tmp time.tmp
rm *.tmp
######################################
echo " Processo con PPID massimo.."
######################################
echo " NOME - PID - PPID - TIME "

ps -le | sort -k 5rn | head -1 | cut -c67-90 > nome.tmp
ps -le | sort -k 5rn | head -1 | cut -c10-15 > pid.tmp
ps -le | sort -k 5rn | head -1 | cut -c18-23 > pidd.tmp
ps -le | sort -k 5rn | head -1 | cut -c58-65 > time.tmp
paste nome.tmp pid.tmp pidd.tmp time.tmp
rm *.tmp
#####################################
echo " Processo con PPID minimo.."
#####################################
echo " NOME - PID - PPID - TIME "

ps -le | sort -k 5rn | tail -2 | head -1 | cut -c67-90 > nome.tmp
ps -le | sort -k 5rn | tail -2 | head -1 | cut -c10-15 > pid.tmp
ps -le | sort -k 5rn | tail -2 | head -1 | cut -c18-23 > pidd.tmp
ps -le | sort -k 5rn | tail -2 | head -1 | cut -c58-65 > time.tmp
paste nome.tmp pid.tmp pidd.tmp time.tmp
rm *.tmp

echo " digitare nome utente :"
read ut
#################################################
echo " I seguenti processi appartengono a $ut.."
#################################################
echo " NOME - PID - PPID - TIME "

# L'opzione '-u' di 'ps' visualizza i processi associati
# ad un particolare utente specificato

ps -lu $ut | cut -c67-90 > nome.tmp
ps -lu $ut | cut -c10-15 > pid.tmp
ps -lu $ut | cut -c18-23 > pidd.tmp
ps -lu $ut | cut -c58-65 > time.tmp

paste nome.tmp pid.tmp pidd.tmp time.tmp
rm *.tmp
