#!/usr/bin/ksh
USAGE="mywho.ksh, visualizza periodicamente ad intervalli di 1 minuto tutti 
gli utenti collegati al sistema, evidenziando eventuali nuovi utenti o utenti 
scollegati"

declare -i  i
declare -i  j
declare -i  k
declare -i  t=0
rm *.tmp
who |cut -c0-10 > new.tmp
who |cut -c0-10 > old.tmp
while ((t < 3))   ### cicla per 3 minuti
 do
   rm old.tmp          # refresh dela lista utenti
   cp new.tmp old.tmp
   rm new.tmp
   who |cut -c0-10 > new.tmp

# 'new[]' e 'old[]' contengono rispettivamente i nomi
# degli utenti correnti e quelli degli utenti precedenti
 
  i=0
  while read line
    do
      for utente in $line
      do
         new[$i]=$utente
      done
      ((i=i+1))
    done < new.tmp
  integer numn=$i  # numero utenti correnti

 j=0
  while read line
    do
      for utente in $line
      do
         old[$j]=$utente
      done
      ((j=j+1))    
    done < old.tmp
integer numo=$j  # numero utenti precedenti

# ora si vede se ci sono stati dei cambiamenti
  k=0
  i=0
  str=" "
  while ((i < numn))
  do
    j=0
    while ((j < numo))
    do
      if [[ ${new[$i]} = ${old[$j]} ]] && [[ ${new[$i]} != $str ]] 
      then
           still[$k]=${new[$i]}  # rilevato un utente gi connesso prima
           ((k=k+1))          # si pu eliminare dai due array, si registra in 'still[]'
           new[$i]=$str        # al posto dell'utente si mette 'space'
           old[$j]=$str
      fi
     ((j=j+1))
    done
    ((i=i+1))
  done
  integer nums=$k  # numero utenti rimasti connessi
  ((numn=numn-nums))
  ((numo=numo-nums))

# Alla fine 'new[]' e 'old[]' conterranno solo i nuovi utenti
# connessi e quelli che si sono disconnessi rispettivamente

  print "\n Utenti rimasti connessi .. $nums\n  ${still[*]}\n"
  print "\n Nuovi utenti .. $numn\n  ${new[*]}\n"
  print "\n Utenti disconnessi .. $numo\n  ${old[*]}\n"
  ((t=t+1))
  sleep 60   # aspetta 1 minuto prima del prossimo report
done



