function [ w,D ] = logistic( X,t,basis,alpha )
%Logistic Logistic regression for basis functions given by basis.

n = size(basis(X(1,:)),2);
N = size(X,1);

Phi = zeros(N,n);
for i=1:N
   Phi(i,:) = basis(X(i,:)); 
end

sigma = @(x)(1./(1+exp(-x)));
y = @(w)(sigma(Phi*w)); %y column
f = @(w)(  sum(t.*log(y(w)) + (1-t).*log(1-y(w))) + alpha/2*w'*w );
df = @(w)( Phi'*(y(w)-t) + alpha*w );
H = @(w)( Phi'*diag(y(w).*(1-y(w)))*Phi + alpha*eye(n)  );

w0 = -1 + 2*rand(n,1); %init point
[w,D] = NR_optimisation(f,df,H,w0);

end

