clear all;
load('nonlinearClassificationDataOverlap.mat');
%load('nonlinearClassificationData.mat');

basis = @(X)([1,X(1),X(2),X(1)^2,X(2)^2,X(1)*X(2)]);
alpha = 0.1;
[w,D] = logistic(X,t,basis,alpha);


%plot using the symbolic toolbox
syms x y;
b = [1,x,y,x^2,y^2,x*y];
i1 = (t==1); i0 = (t==0); 
figure, plot(X(i0,1),X(i0,2),'rx',X(i1,1),X(i1,2),'bx');
hold on;
ezplot(b*w==0,[-10,10,-10,10]);