'Project:       Chapter 4 VB Mail Exercise
'Date:          July 2002
'Programmer:    Robert Price
'Purpose:       This project will calulate the order total from the items entered 
'               and display the order summary. The program will display
'               an error if bad input is detected.
'Folder:        Ex04Mail
Option Strict On
Option Explicit On 

Public Class frmMain
    Inherits System.Windows.Forms.Form

    'Module level variables used for running totals.
    Dim mdecSubtotal As Decimal
    Dim mintItems As Integer

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
    Friend WithEvents txtZip As System.Windows.Forms.TextBox
    Friend WithEvents txtState As System.Windows.Forms.TextBox
    Friend WithEvents txtCity As System.Windows.Forms.TextBox
    Friend WithEvents Label3 As System.Windows.Forms.Label
    Friend WithEvents txtAddress As System.Windows.Forms.TextBox
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents txtName As System.Windows.Forms.TextBox
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents GroupBox2 As System.Windows.Forms.GroupBox
    Friend WithEvents txtPrice As System.Windows.Forms.TextBox
    Friend WithEvents Label4 As System.Windows.Forms.Label
    Friend WithEvents txtQuantity As System.Windows.Forms.TextBox
    Friend WithEvents Label5 As System.Windows.Forms.Label
    Friend WithEvents txtDesc As System.Windows.Forms.TextBox
    Friend WithEvents Label6 As System.Windows.Forms.Label
    Friend WithEvents GroupBox3 As System.Windows.Forms.GroupBox
    Friend WithEvents radGround As System.Windows.Forms.RadioButton
    Friend WithEvents radExpress As System.Windows.Forms.RadioButton
    Friend WithEvents btnNext As System.Windows.Forms.Button
    Friend WithEvents txtSummary As System.Windows.Forms.TextBox
    Friend WithEvents Label7 As System.Windows.Forms.Label
    Friend WithEvents btnExit As System.Windows.Forms.Button
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.GroupBox1 = New System.Windows.Forms.GroupBox()
        Me.txtZip = New System.Windows.Forms.TextBox()
        Me.txtState = New System.Windows.Forms.TextBox()
        Me.txtCity = New System.Windows.Forms.TextBox()
        Me.Label3 = New System.Windows.Forms.Label()
        Me.txtAddress = New System.Windows.Forms.TextBox()
        Me.Label2 = New System.Windows.Forms.Label()
        Me.txtName = New System.Windows.Forms.TextBox()
        Me.Label1 = New System.Windows.Forms.Label()
        Me.GroupBox2 = New System.Windows.Forms.GroupBox()
        Me.btnNext = New System.Windows.Forms.Button()
        Me.txtPrice = New System.Windows.Forms.TextBox()
        Me.Label4 = New System.Windows.Forms.Label()
        Me.txtQuantity = New System.Windows.Forms.TextBox()
        Me.Label5 = New System.Windows.Forms.Label()
        Me.txtDesc = New System.Windows.Forms.TextBox()
        Me.Label6 = New System.Windows.Forms.Label()
        Me.GroupBox3 = New System.Windows.Forms.GroupBox()
        Me.radExpress = New System.Windows.Forms.RadioButton()
        Me.radGround = New System.Windows.Forms.RadioButton()
        Me.txtSummary = New System.Windows.Forms.TextBox()
        Me.Label7 = New System.Windows.Forms.Label()
        Me.btnExit = New System.Windows.Forms.Button()
        Me.GroupBox1.SuspendLayout()
        Me.GroupBox2.SuspendLayout()
        Me.GroupBox3.SuspendLayout()
        Me.SuspendLayout()
        '
        'GroupBox1
        '
        Me.GroupBox1.Controls.Add(Me.txtZip)
        Me.GroupBox1.Controls.Add(Me.txtState)
        Me.GroupBox1.Controls.Add(Me.txtCity)
        Me.GroupBox1.Controls.Add(Me.Label3)
        Me.GroupBox1.Controls.Add(Me.txtAddress)
        Me.GroupBox1.Controls.Add(Me.Label2)
        Me.GroupBox1.Controls.Add(Me.txtName)
        Me.GroupBox1.Controls.Add(Me.Label1)
        Me.GroupBox1.Location = New System.Drawing.Point(8, 8)
        Me.GroupBox1.Name = "GroupBox1"
        Me.GroupBox1.Size = New System.Drawing.Size(360, 96)
        Me.GroupBox1.TabIndex = 0
        Me.GroupBox1.TabStop = False
        Me.GroupBox1.Text = "Informazioni Cliente"
        '
        'txtZip
        '
        Me.txtZip.Location = New System.Drawing.Point(288, 63)
        Me.txtZip.Name = "txtZip"
        Me.txtZip.Size = New System.Drawing.Size(64, 20)
        Me.txtZip.TabIndex = 7
        '
        'txtState
        '
        Me.txtState.Location = New System.Drawing.Point(248, 63)
        Me.txtState.MaxLength = 2
        Me.txtState.Name = "txtState"
        Me.txtState.Size = New System.Drawing.Size(32, 20)
        Me.txtState.TabIndex = 6
        '
        'txtCity
        '
        Me.txtCity.Location = New System.Drawing.Point(120, 63)
        Me.txtCity.Name = "txtCity"
        Me.txtCity.Size = New System.Drawing.Size(120, 20)
        Me.txtCity.TabIndex = 5
        '
        'Label3
        '
        Me.Label3.Location = New System.Drawing.Point(0, 63)
        Me.Label3.Name = "Label3"
        Me.Label3.Size = New System.Drawing.Size(112, 23)
        Me.Label3.TabIndex = 4
        Me.Label3.Text = "Citt, Nazione, CAP"
        Me.Label3.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'txtAddress
        '
        Me.txtAddress.Location = New System.Drawing.Point(120, 39)
        Me.txtAddress.Name = "txtAddress"
        Me.txtAddress.Size = New System.Drawing.Size(232, 20)
        Me.txtAddress.TabIndex = 3
        '
        'Label2
        '
        Me.Label2.Location = New System.Drawing.Point(8, 39)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(104, 23)
        Me.Label2.TabIndex = 2
        Me.Label2.Text = "&Indirizzo"
        Me.Label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'txtName
        '
        Me.txtName.Location = New System.Drawing.Point(120, 15)
        Me.txtName.Name = "txtName"
        Me.txtName.Size = New System.Drawing.Size(232, 20)
        Me.txtName.TabIndex = 1
        '
        'Label1
        '
        Me.Label1.Location = New System.Drawing.Point(8, 15)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(104, 23)
        Me.Label1.TabIndex = 0
        Me.Label1.Text = "Nome &Cliente"
        Me.Label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'GroupBox2
        '
        Me.GroupBox2.Controls.Add(Me.btnNext)
        Me.GroupBox2.Controls.Add(Me.txtPrice)
        Me.GroupBox2.Controls.Add(Me.Label4)
        Me.GroupBox2.Controls.Add(Me.txtQuantity)
        Me.GroupBox2.Controls.Add(Me.Label5)
        Me.GroupBox2.Controls.Add(Me.txtDesc)
        Me.GroupBox2.Controls.Add(Me.Label6)
        Me.GroupBox2.Location = New System.Drawing.Point(8, 112)
        Me.GroupBox2.Name = "GroupBox2"
        Me.GroupBox2.Size = New System.Drawing.Size(360, 96)
        Me.GroupBox2.TabIndex = 2
        Me.GroupBox2.TabStop = False
        Me.GroupBox2.Text = "Articoli"
        '
        'btnNext
        '
        Me.btnNext.Location = New System.Drawing.Point(272, 64)
        Me.btnNext.Name = "btnNext"
        Me.btnNext.Size = New System.Drawing.Size(75, 23)
        Me.btnNext.TabIndex = 6
        Me.btnNext.Text = "Art. &Succ."
        '
        'txtPrice
        '
        Me.txtPrice.Location = New System.Drawing.Point(120, 63)
        Me.txtPrice.Name = "txtPrice"
        Me.txtPrice.Size = New System.Drawing.Size(120, 20)
        Me.txtPrice.TabIndex = 5
        '
        'Label4
        '
        Me.Label4.Location = New System.Drawing.Point(8, 63)
        Me.Label4.Name = "Label4"
        Me.Label4.Size = New System.Drawing.Size(104, 23)
        Me.Label4.TabIndex = 4
        Me.Label4.Text = "&Prezzo"
        Me.Label4.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'txtQuantity
        '
        Me.txtQuantity.Location = New System.Drawing.Point(120, 39)
        Me.txtQuantity.Name = "txtQuantity"
        Me.txtQuantity.Size = New System.Drawing.Size(120, 20)
        Me.txtQuantity.TabIndex = 3
        '
        'Label5
        '
        Me.Label5.Location = New System.Drawing.Point(8, 39)
        Me.Label5.Name = "Label5"
        Me.Label5.Size = New System.Drawing.Size(104, 23)
        Me.Label5.TabIndex = 2
        Me.Label5.Text = "&Quantit"
        Me.Label5.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'txtDesc
        '
        Me.txtDesc.Location = New System.Drawing.Point(120, 15)
        Me.txtDesc.Name = "txtDesc"
        Me.txtDesc.Size = New System.Drawing.Size(232, 20)
        Me.txtDesc.TabIndex = 1
        '
        'Label6
        '
        Me.Label6.Location = New System.Drawing.Point(8, 15)
        Me.Label6.Name = "Label6"
        Me.Label6.Size = New System.Drawing.Size(104, 23)
        Me.Label6.TabIndex = 0
        Me.Label6.Text = "&Descrizione"
        Me.Label6.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'GroupBox3
        '
        Me.GroupBox3.Controls.Add(Me.radExpress)
        Me.GroupBox3.Controls.Add(Me.radGround)
        Me.GroupBox3.Location = New System.Drawing.Point(376, 8)
        Me.GroupBox3.Name = "GroupBox3"
        Me.GroupBox3.Size = New System.Drawing.Size(88, 72)
        Me.GroupBox3.TabIndex = 1
        Me.GroupBox3.TabStop = False
        Me.GroupBox3.Text = "Spedizione"
        '
        'radExpress
        '
        Me.radExpress.Location = New System.Drawing.Point(8, 40)
        Me.radExpress.Name = "radExpress"
        Me.radExpress.Size = New System.Drawing.Size(72, 24)
        Me.radExpress.TabIndex = 1
        Me.radExpress.Text = "Ce&lere"
        '
        'radGround
        '
        Me.radGround.Checked = True
        Me.radGround.Location = New System.Drawing.Point(8, 16)
        Me.radGround.Name = "radGround"
        Me.radGround.Size = New System.Drawing.Size(72, 24)
        Me.radGround.TabIndex = 0
        Me.radGround.TabStop = True
        Me.radGround.Text = "&Normale"
        '
        'txtSummary
        '
        Me.txtSummary.Location = New System.Drawing.Point(8, 232)
        Me.txtSummary.Multiline = True
        Me.txtSummary.Name = "txtSummary"
        Me.txtSummary.ScrollBars = System.Windows.Forms.ScrollBars.Both
        Me.txtSummary.Size = New System.Drawing.Size(456, 128)
        Me.txtSummary.TabIndex = 5
        '
        'Label7
        '
        Me.Label7.Location = New System.Drawing.Point(8, 216)
        Me.Label7.Name = "Label7"
        Me.Label7.Size = New System.Drawing.Size(112, 23)
        Me.Label7.TabIndex = 4
        Me.Label7.Text = "Dati Riassuntivi"
        '
        'btnExit
        '
        Me.btnExit.Location = New System.Drawing.Point(392, 176)
        Me.btnExit.Name = "btnExit"
        Me.btnExit.Size = New System.Drawing.Size(75, 23)
        Me.btnExit.TabIndex = 3
        Me.btnExit.Text = "&Esci"
        '
        'frmMain
        '
        Me.AcceptButton = Me.btnNext
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(472, 366)
        Me.Controls.Add(Me.btnExit)
        Me.Controls.Add(Me.txtSummary)
        Me.Controls.Add(Me.Label7)
        Me.Controls.Add(Me.GroupBox3)
        Me.Controls.Add(Me.GroupBox2)
        Me.Controls.Add(Me.GroupBox1)
        Me.Name = "frmMain"
        Me.Text = "Articoli ordinati"
        Me.GroupBox1.ResumeLayout(False)
        Me.GroupBox1.PerformLayout()
        Me.GroupBox2.ResumeLayout(False)
        Me.GroupBox2.PerformLayout()
        Me.GroupBox3.ResumeLayout(False)
        Me.ResumeLayout(False)
        Me.PerformLayout()

    End Sub

#End Region

    Private Sub btnNext_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNext.Click
        Dim decPrice As Decimal
        Dim intQuantity As Integer
        Dim decExtendedPrice As Decimal
        Dim decShipping As Decimal
        Dim decTotal As Decimal
        Dim strSummary As String

        'Calculate the item and display the summary.

        'Validate user input
        Try
            intQuantity = CInt(txtQuantity.Text)
        Catch MyErr As Exception
            MessageBox.Show("Errore nei dati di input: " & MyErr.Message, "Dato errati", MessageBoxButtons.OK, MessageBoxIcon.Error)
            txtQuantity.Focus()
            Exit Sub
        End Try
        Try
            decPrice = CDec(txtPrice.Text)
        Catch MyErr As Exception
            MessageBox.Show("Errore nei dati di input: " & MyErr.Message, "Dati errati", MessageBoxButtons.OK, MessageBoxIcon.Error)
            txtPrice.Focus()
            Exit Sub
        End Try

        'Calculate the item total
        decExtendedPrice = decPrice * intQuantity

        'Accumulate the totals
        mdecSubtotal += decExtendedPrice
        mintItems += intQuantity

        'Calculate the shipping and total
        If mdecSubtotal < 15 Then
            decShipping = CDec(4.95)
        ElseIf mdecSubtotal < 50 Then
            decShipping = CDec(6.95)
        ElseIf mdecSubtotal < 100 Then
            decShipping = CDec(8.95)
        ElseIf mdecSubtotal < 200 Then
            decShipping = CDec(10.95)
        Else
            decShipping = CDec(12.95)
        End If
        If radExpress.Checked = True Then
            decShipping += 10
        End If
        decTotal = mdecSubtotal + decShipping

        'Display the summary
        strSummary = txtName.Text & vbCrLf
        strSummary &= txtAddress.Text & vbCrLf
        strSummary &= txtZip.Text & " " & txtCity.Text & " - " & txtState.Text & vbCrLf & vbCrLf
        strSummary &= "Articoli ordinati: " & mintItems.ToString & vbCrLf & vbCrLf
        strSummary &= "Totale parziale: " & FormatCurrency(mdecSubtotal, 2) & vbCrLf
        strSummary &= "Spese di spedizione: " & FormatNumber(decShipping, 2) & vbCrLf
        strSummary &= "Totale: " & FormatCurrency(decTotal, 2)
        txtSummary.Text = strSummary

        'Now clear out the text boxes for the next item.
        With txtDesc
            .Text = ""
            .Focus()
        End With
        txtQuantity.Text = ""
        txtPrice.Text = ""
    End Sub

    Private Sub btnExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnExit.Click
        'Close and exit the program.

        Me.Close()
    End Sub
End Class
