﻿Public Class Form1

    'Calcolo dello zero della funzione utilizzando una soglia prefissata per la differenza tra il valore della funzione e zero.
    Private Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click
        'I due valori iniziali
        Dim x1 As Double
        Dim x2 As Double

        'La soluzione
        Dim sol As Double

        'La soglia di tolleranza del valore della funzione rispetto al valore zero
        Dim prec As Double

        'Verifica della regolarità del primo valore
        Try
            x1 = CDbl(TextBox1.Text)
        Catch
            MessageBox.Show("Errore nell'inserimento del numero", "Errore", MessageBoxButtons.OK, MessageBoxIcon.Error)
            TextBox1.Focus()
            TextBox1.SelectAll()
            Exit Sub
        End Try

        'Verifica della regolarità del secondo valore
        Try
            x2 = CDbl(TextBox2.Text)
        Catch
            MessageBox.Show("Errore nell'inserimento del numero", "Errore", MessageBoxButtons.OK, MessageBoxIcon.Error)
            TextBox2.Focus()
            TextBox2.SelectAll()
            Exit Sub
        End Try
        Try
            prec = CDbl(TextBox3.Text)
        Catch
            MessageBox.Show("Errore nell'inserimento del numero", "Errore", MessageBoxButtons.OK, MessageBoxIcon.Error)
            TextBox3.Focus()
            TextBox3.SelectAll()
            Exit Sub
        End Try

        'Verifica della discordanza di segno dei valori nei punti iniziali
        If f(x1) * f(x2) < 0 Then
            sol = calcolaSoluzione(x1, x2, prec)
            Label3.Text = "Soluzione: " & sol
        Else
            MessageBox.Show("I punti iniziali non vanno bene! " & f(x1) & " " & f(x2))
        End If
    End Sub

    'La funzione di cui si vuole trovare uno zero
    Private Function f(x As Double) As Double
        Return x ^ 3 - x ^ 2 + x - 1
    End Function

    'Il calcolo dello zero con il metodo di bisezione
    'u, v - valori dei punti iniziali
    'epsilon - soglia di tolleranza per il valore della funzione rispetto allo zero
    Private Function calcolaSoluzione(u As Double, v As Double, epsilon As Double) As Double

        'I punti convergenti alla soluzione
        Dim an As Double
        Dim bn As Double

        'Il punto di mezzo
        Dim cn As Double

        'Assegnazione dei valori iniziali
        bn = v
        an = u

        'Calcolo del punto di mezzo
        cn = (bn + an) / 2

        'Ciclo iterativo del metodo
        'Il ciclo si arresta quando il valore assoluto della funzione nel punto di mezzo del sottointervallo
        ' è inferiore o uguale alla soglia 
        Do While Math.Abs(f(cn)) > epsilon
            'Assegnazione del valore intermedio ad uno dei due punti
            If f(cn) * f(an) < 0 Then
                bn = cn
            Else
                an = cn
            End If
            'Calcolo del valore intermedio
            cn = (bn + an) / 2
            'Console.WriteLine(cn)
            
        Loop
        'Restituzione del valore appossimato dello zero
        Return cn
    End Function

    'Il calcolo dello zero con il metodo di bisezione in base alla soglia di precisione indicata sul form
    Private Sub Button2_Click(sender As Object, e As EventArgs) Handles Button2.Click
        'I due valori iniziali
        Dim x1 As Double
        Dim x2 As Double

        'La soluzione
        Dim sol As Double

        'La precisione indicata sul form
        Dim prec As Double

        'Verifica della regolarità del primo valore
        Try
            x1 = CDbl(TextBox1.Text)
        Catch
            MessageBox.Show("Errore nell'inserimento del numero", "Errore", MessageBoxButtons.OK, MessageBoxIcon.Error)
            TextBox1.Focus()
            TextBox1.SelectAll()
            Exit Sub
        End Try

        'Verifica della regolarità del secondo valore
        Try
            x2 = CDbl(TextBox2.Text)
        Catch
            MessageBox.Show("Errore nell'inserimento del numero", "Errore", MessageBoxButtons.OK, MessageBoxIcon.Error)
            TextBox2.Focus()
            TextBox2.SelectAll()
            Exit Sub
        End Try

        'Verifica della regolarità della precisione richiesta
        Try
            prec = CDbl(TextBox3.Text)
        Catch
            MessageBox.Show("Errore nell'inserimento del numero", "Errore", MessageBoxButtons.OK, MessageBoxIcon.Error)
            TextBox3.Focus()
            TextBox3.SelectAll()
            Exit Sub
        End Try

        'Verifica della discordanza di segno dei valori nei punti iniziali
        If f(x1) * f(x2) < 0 Then
            sol = calcolaSoluzionePrecis(x1, x2, prec)
            Label3.Text = "Soluzione: " & sol
        Else
            MessageBox.Show("I punti iniziali non vanno bene! " & f(x1) & " " & f(x2))
        End If
    End Sub

    'Il calcolo dello zero con il metodo di bisezione in base ad una precisione indicata
    'u, v - valori dei punti iniziali
    'epsilon - precisione
    Private Function calcolaSoluzionePrecis(u As Double, v As Double, epsilon As Double) As Double

        'I punti convergenti alla soluzione
        Dim an As Double
        Dim bn As Double

        'Il punto di mezzo
        Dim cn As Double

        'Il numero di cicli da eseguire
        Dim n As Integer

        'L'indice del ciclo
        Dim i As Integer

        'Assegnazione dei valori iniziali
        bn = v
        an = u

        'Determinazione del numero di cicli da eseguire
        n = CInt(Math.Ceiling(Math.Log((bn - an) / epsilon, 2) - 1))

        'Ciclo iterativo del metodo
        'Il ciclo viene eseguito il numero di volte necessario a raggiungere la precisione richiesta
        For i = 1 To n

            'Calcolo del punto di mezzo
            cn = (bn + an) / 2
            'Console.WriteLine(cn)

            'Assegnazione del valore intermedio ad uno dei due punti
            If f(cn) = 0 Then
                Exit For
            ElseIf f(cn) * f(an) < 0 Then
                bn = cn
            Else
                an = cn
            End If
        Next i

        'Restituzione del valore appossimato dello zero
        Return cn
    End Function
End Class
