﻿Imports System.IO

Public Class Form1

    Private Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click
        'Dichiarazione di un DialogResult per ottenere la risposta dalla finestra di dialogo Salva
        Dim dlgResult As DialogResult

        'Dichiarazione di uno StreamWriter per scrivere nel file
        Dim datSentence As StreamWriter

        'La finestra di dialogo Salva si aprirà nella cartella del programma
        SaveFileDialog1.InitialDirectory = Application.StartupPath

        'Si lancia la finestra di dialogo Salva e si preleva la risposta
        dlgResult = SaveFileDialog1.ShowDialog()

        'Se l'utente non ha annullato l'operazione, si crea il file e si scrive in esso il contenuto del textbox
        'altrimenti si segnala l'avvenuta cancellazione dell'operazione
        If dlgResult <> Windows.Forms.DialogResult.Cancel Then
            'Si apre il file
            datSentence = New StreamWriter(SaveFileDialog1.FileName)

            'Si scrive nel file il contenuto della casella di testo
            datSentence.WriteLine(TextBox1.Text)

            'Si chiude il file
            datSentence.Close()
        Else
            MessageBox.Show("Operazione annullata", "Annullamento", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End If
    End Sub

    Private Sub Button2_Click(sender As Object, e As EventArgs) Handles Button2.Click
        'Dichiarazione di un DialogResult per ottenere la risposta dalla finestra di dialogo Apri
        Dim dlgResult As DialogResult

        'Dichiarazione di uno StreamReader per leggere il file
        Dim datSentence As StreamReader

        'La finestra di dialogo Apri si aprirà nella cartella del programma
        OpenFileDialog1.InitialDirectory = Application.StartupPath

        'Si lancia la finestra di dialogo Apri e si preleva la risposta
        dlgResult = OpenFileDialog1.ShowDialog()

        'Se l'utente non ha annullato l'operazione, si legge il file e si scrive il suo contenuto nel textbox
        'altrimenti si segnala l'avvenuta cancellazione dell'operazione
        'Se il file non esiste, si dà una segnalazione
        Try
            If dlgResult <> Windows.Forms.DialogResult.Cancel Then
                'Si apre il file
                datSentence = New StreamReader(OpenFileDialog1.FileName)

                'Si ripulisce il textbox
                TextBox2.Text = ""

                'Si leggono le righe di testo del file e si visualizzano nella textbox
                Do Until datSentence.Peek() = -1
                    TextBox2.Text &= datSentence.ReadLine & ControlChars.NewLine
                Loop

                'In alternativa si può leggere tutto il contenuto del file in un colpo solo
                '(commentare il loop sopra per provare):
                'TextBox2.Text = datSentence.ReadToEnd

                'Si chiude il file
                datSentence.Close()
            Else
                MessageBox.Show("Operazione annullata", "Annullamento", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            End If
        Catch
            MessageBox.Show("Operazione annullata: il file non esiste", "File non esistente", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub
End Class
