import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JComponent;

/**
   A component that draws two rectangles.
*/
public class RectangleComponent extends JComponent
{  
   public void paintComponent(Graphics g)
   {  
      // Recover Graphics2D
      Graphics2D g2 = (Graphics2D) g;

      // Construct a rectangle and draw it
      Rectangle box1 = new Rectangle(5, 10, 20, 30);
      g2.draw(box1);

      // Construct a rectangle and draw it
      Rectangle box2 = new Rectangle(20, 30, 20, 30);

      // Draw moved rectangle
      g2.draw(box2);
      
      Rectangle box3;
      box3 = box1.intersection(box2);
      box3.translate(60, 80);
      g2.draw(box3);
   }
}
