/*
 * Decompiled with CFR 0.152.
 */
public class EquationSolver {
    private double a;
    private double b;
    private double c;
    static int counter = 0;

    public EquationSolver(double a_coeff, double b_coeff, double c_coeff) {
        this.a = a_coeff;
        this.b = b_coeff;
        this.c = c_coeff;
    }

    public EquationSolver() {
        this(0.0, 0.0, 0.0);
    }

    public double geta() {
        return this.a;
    }

    public void seta(double a_coeff) {
        this.a = a_coeff;
    }

    public double getb() {
        return this.b;
    }

    public void setb(double b_coeff) {
        this.b = b_coeff;
    }

    public double getc() {
        return this.c;
    }

    public void setc(double c_coeff) {
        this.c = c_coeff;
    }

    public int getCounter() {
        return counter;
    }

    public String solve() {
        String messaggio;
        if (this.a == 0.0) {
            messaggio = this.b != 0.0 ? "Soluzione: " + -this.c / this.b : (this.c == 0.0 ? "L'equazione ha infinite soluzioni" : "L'equazione non ha soluzioni");
        } else {
            double delta = Math.pow(this.b, 2.0) - 4.0 * this.a * this.c;
            if (delta > 0.0) {
                double soluzione1 = (-this.b + Math.sqrt(delta)) / (2.0 * this.a);
                double soluzione2 = (-this.b - Math.sqrt(delta)) / (2.0 * this.a);
                messaggio = "Soluzioni: " + soluzione1 + " e " + soluzione2;
            } else if (delta == 0.0) {
                double soluzione1 = (-this.b + Math.sqrt(delta)) / (2.0 * this.a);
                messaggio = "Soluzione: " + soluzione1;
            } else {
                messaggio = "L'equazione non ha soluzione";
            }
        }
        ++counter;
        return messaggio;
    }
}

