
public class EquationSolver {

    private double a, b, c;
    static int counter = 0;

    // Costruttore: i parametri sono i coefficienti dell'equazione di grado minore o uguale a due
    public EquationSolver(double a_coeff, double b_coeff, double c_coeff) {
        a = a_coeff;
        b = b_coeff;
        c = c_coeff;
    }

    public EquationSolver() {
        this(0, 0, 0);
    }

    public double geta() {
        return a;
    }

    public void seta(double a_coeff) {
        a = a_coeff;
    }

    public double getb() {
        return b;
    }

    public void setb(double b_coeff) {
        b = b_coeff;
    }

    public double getc() {
        return c;
    }

    public void setc(double c_coeff) {
        c = c_coeff;
    }

    public int getCounter() {
        return counter;
    }

    public String solve() {
        // Discriminante
        double delta;
        // Soluzioni
        double soluzione1, soluzione2;
        // Stringa per il messaggio da visualizzare
        String messaggio;

        // Caso in cui il coefficiente del termine di grado 2 � nullo
        if (a == 0) {
            if (b != 0) {
                messaggio = "Soluzione: " + (-c / b);
            } else {
                if (c == 0) {
                    messaggio = "L'equazione ha infinite soluzioni";
                } else {
                    messaggio = "L'equazione non ha soluzioni";
                }
            }
        } else {                                                   // Caso in cui il coefficiente del termine di grado 2 � diverso da zero
            // Viene calcolato il discriminante
            delta = (double) Math.pow(b, 2) - 4 * a * c;

            // Risoluzione dell'equazione
            if (delta > 0) {                                          // Due soluzioni
                soluzione1 = (double) ((-b + Math.sqrt(delta)) / (2 * a));
                soluzione2 = (double) ((-b - Math.sqrt(delta)) / (2 * a));
                messaggio = "Soluzioni: " + soluzione1 + " e " + soluzione2;
            } else if (delta == 0) {                                  // Una soluzione
                soluzione1 = (double) ((-b + Math.sqrt(delta)) / (2 * a));
                messaggio = "Soluzione: " + soluzione1;
            } else {                                                  // Nessuna soluzione
                messaggio = "L'equazione non ha soluzione";
            };
        }
        // Si incrementa il contatore
        counter++;

        // La stringa contenente le soluzioni viene restituita
        return messaggio;
    }
}
