/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class Circle {
    private double xCenter;
    private double yCenter;
    private double radius;
    private Color color;

    public Circle(double x, double y, double r, Color col) {
        this.xCenter = x;
        this.yCenter = y;
        this.radius = r;
        this.color = col;
    }

    public Circle(Point2D.Double p, double r, Color col) {
        this.xCenter = p.getX();
        this.yCenter = p.getY();
        this.radius = r;
        this.color = col;
    }

    public Circle(double x, double y, double r) {
        this(x, y, r, Color.BLACK);
    }

    public void setColor(Color aColor) {
        this.color = aColor;
    }

    public void draw(Graphics2D g2) {
        if (this.radius < 0.0) {
            return;
        }
        g2.setColor(this.color);
        Ellipse2D.Double circle = new Ellipse2D.Double(this.xCenter - this.radius, this.yCenter - this.radius, 2.0 * this.radius, 2.0 * this.radius);
        g2.draw(circle);
    }

    public boolean intersects(Circle other) {
        double totalRadius = this.radius + other.radius;
        double dx = this.xCenter - other.xCenter;
        double dy = this.yCenter - other.yCenter;
        double distance = Math.sqrt(dx * dx + dy * dy);
        return totalRadius >= distance;
    }
}

