/**
   This program tests the DataSet class.
*/
public class DataSetTester
{
   public static void main(String[] args)
   {
      // Creo un oggetto DataSet
      DataSet bankData = new DataSet();

      // Aggiungo al DataSet tre conti correnti:
      // uno a saldo zero
      // uno a saldo 10.000
      // uno a saldo 2.000
      bankData.add(new BankAccount(0));
      bankData.add(new BankAccount(10000));
      bankData.add(new BankAccount(2000));

      // Il saldo medio sarà 4.000
      // Il saldo massimo sarà 10.000
      System.out.println("Average balance: "
            + bankData.getAverage());
      System.out.println("Expected: 4000");
      Measurable max = bankData.getMaximum();
      System.out.println("Highest balance: " 
         + max.getMeasure());
      System.out.println("Expected: 10000");

      // Creo un altro oggetto DataSet
      DataSet coinData = new DataSet();

      // Aggiungo al DataSet tre monete:
      // una di 25 centesimi
      // una di 10 centesimi
      // una di cinque centesimi
      coinData.add(new Coin(0.25, "quarter"));
      coinData.add(new Coin(0.1, "dime"));
      coinData.add(new Coin(0.05, "nickel"));

      // Il valore medio delle monete sarà 4.000 4/30
      // Il valore massimo delle monete sarà 25 centesimi
      System.out.println("Average coin value: "
            + coinData.getAverage());
      System.out.println("Expected: 0.133");
      max = coinData.getMaximum();
      System.out.println("Highest coin value: "
            + max.getMeasure());
      System.out.println("Expected: 0.25");
   }
}
