# Input filename - this is to be passed to the
# main C function that contains data-loading routines
# to get the input from the file (eg an array, etc.)
EXECUTABLE=$1
FILETEST=$2

echo
echo "~~> Running test: '$FILETEST' with '$EXECUTABLE'"
echo

# Main program call with the specified input
echo "~~~~~~~~~~ Output from C program ~~~~~~~~~~~"
output=$(./$EXECUTABLE $FILETEST)
echo "$output"
echo "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo

# The run program dumps results to a folder
# named "output", using the same filename of $FILETEST.
# The expected output is available in a folder named
# "result", again under filename $FILETEST.

if test -f "output/$FILETEST"; then
	echo "Found output/$FILETEST - can check for results."
else
	echo "Output file output/$FILETEST does not exist."
	echo "Your program does not run and save results as expected!"
	echo 
  	echo "-----------------"
 	echo "| Result: Fail! |"
  	echo "-----------------"
  	echo
  	echo "Test with '$FILETEST' and '$EXECUTABLE' failed."
  	exit 1
fi

#
# A  diff-operation between the two files should
# return no differences, implying the computed and 
# expected file contents are exactly the same.
my_diff=$(diff output/$FILETEST result/$FILETEST)
diff_result=$(diff output/$FILETEST result/$FILETEST | wc -l)
#ndiff = $(wc -l $diff_file)

echo
echo "Results (your output)"
echo "--------"
echo "$(cat output/$FILETEST)"
echo "--------"

echo
echo "Results (correct answer)"
echo "--------"
echo "$(cat result/$FILETEST)"
echo "--------"

echo
echo "Results differences"
echo "--------"
echo "$my_diff"
echo "--------"


#echo
#echo "~~~> n = $diff_result differences ..."
#echo

# Establish result (0 = PASS)
if [ $diff_result -eq 0 ] ; then
  echo "-----------------"
  echo "| Result: Pass! |"
  echo "-----------------"
  echo
  echo "Test with '$FILETEST' and '$EXECUTABLE' passed."
  exit 0
else
  echo "-----------------"
  echo "| Result: Fail! |"
  echo "-----------------"
  echo
  echo "Test with '$FILETEST' and '$EXECUTABLE' failed."
  exit 1
fi


