import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;
import java.text.*;
import java.io.*;

/**
 */
public class BiliardiECaos extends JPanel implements ActionListener, ChangeListener, Runnable
{

    /** Versione */
    static String VERSIONE="1.1";

    /** Conversione radianti-gradi */
    static double RAD2DEG=180.0/Math.PI;
    /** Conversione gradi-radianti */
    static double DEG2RAD=Math.PI/180.0;

    // Parametri predefiniti
    /** Numero di iterazioni */
    static int    PREDEF_NITER  = 0;
    /** Tipo di biliardo */
    static int PREDEF_FORMA = Biliardo.RETTANGOLO;
    /** Lato orizzontale */
    static double PREDEF_LATOORIZZ = 0.5;
    /** Posizione iniziale (x) */
    static double PREDEF_POSX   = 0.0;
    /** Posizione iniziale (y) */
    static double PREDEF_POSY   = 0.0;
    /** Angolo di partenza */
    static double PREDEF_ANGOLO = 0.0;
    /** Velocita' di animazione in unita'/s */
    static double VELOCITA = 5.; 

    // Parametri di visualizzazione
    static int DIMAREA_X=300;  // semiampiezza dell'area di disegno
    static int DIMAREA_Y=300;  // semiampiezza dell'area di disegno
    static int DT_ANIM=5;      // timestep per l'animazione (ms)


    // I file in cui salvare la traiettoria
    static String FILE_TRAIETTORIA =new String("traiettoria.txt");
    static String FILE_INFORMAZIONI=new String("traiettinfo.txt");
    private boolean abilitaScrittura;


    // Notazione scientifica con diversi decimali
    static DecimalFormat notazScient6
	= new DecimalFormat( "0.000000E00;-0.000000E00",
			     new DecimalFormatSymbols(Locale.US) );
    // Numeri con tre decimali
    static DecimalFormat notaz9Decimali
	= new DecimalFormat( "0.000000000",
			     new DecimalFormatSymbols(Locale.US) );
    // Numeri interi
    static DecimalFormat notazInteri
	= new DecimalFormat( "#;-#");


    // Gli oggetti che contengono la traiettoria. Vedi file "Biliardo.java"
    Biliardo biliardo;
    Biliardo vecchioBiliardo;
    int forma=PREDEF_FORMA;

    // L'area in cui tracciare la traiettoria
    AreaDisegno areaDisegno;
    // Il pannello comandi/parametri
    JPanel pannelloLaterale;

    // Pulsanti di controllo
    JButton pulsPlay, pulsStop,
	pulsCalcola, pulsPulisci, pulsContinua, pulsInverti, pulsScrivi;

    // Campi di input
    JFormattedTextField inp_latoOrizz, inp_niter, inp_pos0x, inp_pos0y, inp_angolo;
    JRadioButton inp_formaRettangolo, inp_formaStadio;

    // Selettore per la velocita' di animazione
    JSlider selettVelocita;
    static double SCALAVELOCITA=1000.;

    // Oggetti per l'animazione
    Thread animThread;
    boolean animazioneInCorso=false;
    //int iterazOra;
    double distanzaOra=0;
    double velocita;


    /**
     * Costruttore del pannello per il calcolo della traiettoria in un
     * biliardo
     */
    public BiliardiECaos(boolean _abilitaScrittura) {
	abilitaScrittura=_abilitaScrittura;
	
	// Crea il sotto-pannello controllo
 	pulsPulisci=new JButton("Pulisci biliardo"); pulsPulisci.addActionListener(this);
 	pulsContinua=new JButton("per proseguire dall'ultima iterazione"); pulsContinua.addActionListener(this);
 	pulsInverti=new JButton("per invertire dall'ultima iterazione"); pulsInverti.addActionListener(this);
 	pulsCalcola =new JButton("Calcolo");     pulsCalcola.addActionListener(this);
	if (abilitaScrittura) {
	    pulsScrivi=new JButton("Scrivi traiettoria su file"); pulsScrivi.addActionListener(this);
	}
	pulsPlay=new JButton("Play");                      pulsPlay.addActionListener(this);
	pulsStop=new JButton("Stop");                      pulsStop.addActionListener(this);
	JPanel pannAnimaz=new JPanel();
	pannAnimaz.setLayout(new GridLayout(1,3,2,2));
	pannAnimaz.add(new JLabel("Animazione:"));
	pannAnimaz.add(pulsPlay);
	pannAnimaz.add(pulsStop);
	selettVelocita=new JSlider(JSlider.HORIZONTAL,
				   (int) (SCALAVELOCITA*0),
				   (int) (SCALAVELOCITA*20),
				   (int) (SCALAVELOCITA*VELOCITA));
	selettVelocita.setPaintTicks(true);
	selettVelocita.setMajorTickSpacing((int) (SCALAVELOCITA*5));
	selettVelocita.setMinorTickSpacing((int) (SCALAVELOCITA*1));
	selettVelocita.addChangeListener(this);
	velocita=((double)selettVelocita.getValue())/SCALAVELOCITA;
	JPanel pannVelocita=new JPanel();
	pannVelocita.setLayout(new BorderLayout(0,0));
	pannVelocita.add(new JLabel("Velocita':"),BorderLayout.WEST);
	pannVelocita.add(selettVelocita,BorderLayout.CENTER);
	JPanel pannControllo=new JPanel();
	pannControllo.setLayout(new GridLayout( (abilitaScrittura?10:9), 1 ,2 ,10 ));
 	pannControllo.add(pulsPulisci);
	pannControllo.add(new JLabel("Imposta parametri:"));
 	pannControllo.add(pulsContinua);
 	pannControllo.add(pulsInverti);
	pannControllo.add(new JLabel(""));
	pannControllo.add(pulsCalcola);
	if (abilitaScrittura) pannControllo.add(pulsScrivi);
	pannControllo.add(new JLabel(""));
	pannControllo.add(pannAnimaz);
	pannControllo.add(pannVelocita);

	// Crea il sottopannello parametri
	inp_formaRettangolo=new JRadioButton(new String("Rettangolare"));
	inp_formaRettangolo.setSelected((PREDEF_FORMA==Biliardo.RETTANGOLO));
	inp_formaRettangolo.addActionListener(this);
	inp_formaStadio=new JRadioButton(new String("Stadio"));
	inp_formaStadio.setSelected((PREDEF_FORMA==Biliardo.STADIO));
	inp_formaStadio.addActionListener(this);
	inp_latoOrizz=new JFormattedTextField(notaz9Decimali); inp_latoOrizz.setValue(PREDEF_LATOORIZZ);
	inp_niter =new JFormattedTextField(notazInteri);  inp_niter.setValue(PREDEF_NITER);
	inp_pos0x =new JFormattedTextField(notaz9Decimali); inp_pos0x.setValue(PREDEF_POSX);
	inp_pos0y =new JFormattedTextField(notaz9Decimali); inp_pos0y.setValue(PREDEF_POSY);
	inp_angolo=new JFormattedTextField(notaz9Decimali); inp_angolo.setValue(PREDEF_ANGOLO);
	JPanel pannParametri=new JPanel();
	pannParametri.setLayout(new GridLayout(8,2,2,2));
	pannParametri.add(new JLabel("Tipo di biliardo:"));  pannParametri.add(new JLabel(""));
	pannParametri.add(inp_formaRettangolo);         
        pannParametri.add(inp_formaStadio);
	pannParametri.add(new JLabel("Lato orizzontale") ); pannParametri.add(inp_latoOrizz);
	pannParametri.add(new JLabel(""));                  pannParametri.add(new JLabel(""));
	pannParametri.add(new JLabel("Numero di rimbalzi")); pannParametri.add(inp_niter);
	pannParametri.add(new JLabel("Posizione iniz. x")); pannParametri.add(inp_pos0x);
	pannParametri.add(new JLabel("Posizione iniz. y")); pannParametri.add(inp_pos0y);
	pannParametri.add(new JLabel("Angolo iniz. (gradi)")   ); pannParametri.add(inp_angolo);

	// Inizializza il moto sul biliardo con i parametri predefiniti
	nuovoCalcolo();


	// Componi il pannello laterale
	pannelloLaterale=new JPanel();
	pannelloLaterale.setLayout(new BorderLayout(0,20));
	pannelloLaterale.add(pannControllo,BorderLayout.CENTER);
	pannelloLaterale.add(pannParametri,BorderLayout.NORTH);
	JPanel pannLat1=new JPanel();
	pannLat1.add(pannelloLaterale);

	// Crea l'area del disegno
	areaDisegno=new AreaDisegno();
	
	// Componi il pannello complessivo
	this.setLayout(new BorderLayout(2,2));
	this.add(areaDisegno,BorderLayout.CENTER);
	this.add(pannLat1,BorderLayout.EAST);
    }


    /**
     * Leggi i parametri di input e effettua il calcolo della traiettoria
     */
    public void nuovoCalcolo() {
	try {
	    double l=notaz9Decimali.parse(inp_latoOrizz.getText()).doubleValue();
	    PREDEF_LATOORIZZ = l;
	    int    n=notazInteri.parse(   inp_niter.getText()).intValue();
	    double x=notaz9Decimali.parse(inp_pos0x.getText()).doubleValue();
	    double y=notaz9Decimali.parse(inp_pos0y.getText()).doubleValue();
	    double a=notaz9Decimali.parse(inp_angolo.getText()).doubleValue()*DEG2RAD;
	    // Controlla se x e y sono dentro il nuovo biliardo
	    Biliardo biliardoControllo=new Biliardo(forma, l, 1, 0.0, 0.0, 0.0);
	    if (biliardoControllo.eDentro(x,y)) {
		vecchioBiliardo=biliardo;
		biliardo=new Biliardo (forma, l, n, x, y, a);
		animazioneInCorso=false;
		distanzaOra=0;
		// Se e' cambiata la forma, cancella la vecchia traiettoria
		if (vecchioBiliardo!=null)
		    if ( (biliardo.forma!=vecchioBiliardo.forma) ||
			 (biliardo.metaLatoOrizz()!=vecchioBiliardo.metaLatoOrizz()) )
			vecchioBiliardo=null;
	    } else {
		JOptionPane.showMessageDialog
		    (this, "La biglia e' inizialmente fuori del biliardo!",
		     "Biliardi e caos - Errore", JOptionPane.ERROR_MESSAGE);
	    }
	}
	catch(ParseException nfe) {
	    JOptionPane.showMessageDialog
		(this, "Controlla i valori inseriti!",
		 "Biliardi e caos - Errore", JOptionPane.ERROR_MESSAGE);
	}
	inp_latoOrizz.setValue(biliardo.metaLatoOrizz());
    }


    private void resetParametri() {
	inp_latoOrizz.setValue(PREDEF_LATOORIZZ);
	inp_niter.setValue(PREDEF_NITER);
	inp_pos0x.setValue(PREDEF_POSX);
	inp_pos0y.setValue(PREDEF_POSY);
	inp_angolo.setValue(PREDEF_ANGOLO);
    }


    private void pulisciBiliardo() {
	resetParametri();
	nuovoCalcolo();
	vecchioBiliardo=null;
	//areaDisegno.paintComponent(areaDisegno.getGraphics());
    }


    /**
     * Funzione eseguita ogni volta che si clicca su un pulsante
     */
    public void actionPerformed(ActionEvent e) {
	if (e.getSource()== pulsPlay) {
	    distanzaOra=0;
	    if (!animazioneInCorso) stopIfRunning(false);
	} else {
	    stopIfRunning(true);
	    distanzaOra=0;
	    //areaDisegno.paintComponent(areaDisegno.getGraphics());
	}
	//
	if (e.getSource()== pulsCalcola) {
	    nuovoCalcolo();
	    //areaDisegno.paintComponent(areaDisegno.getGraphics());
	}
	else if (e.getSource()== inp_formaRettangolo) {
	    inp_formaRettangolo.setSelected(true);
	    inp_formaStadio.setSelected(false);
	    if (forma!=Biliardo.RETTANGOLO) {
		forma=Biliardo.RETTANGOLO;
		pulisciBiliardo();
	    }
	}
	else if (e.getSource()== inp_formaStadio) {
	    inp_formaStadio.setSelected(true);
	    inp_formaRettangolo.setSelected(false);
	    if (forma!=Biliardo.STADIO) {
		forma=Biliardo.STADIO;
		pulisciBiliardo();
	    }
	}
	else if (e.getSource()== pulsPulisci) {
	    pulisciBiliardo();
	}
	else if (e.getSource()== pulsContinua) {
	    int ultima=biliardo.niter-1;
	    inp_pos0x.setText( notaz9Decimali.format(biliardo.pos_x [ultima]));
	    inp_pos0y.setText( notaz9Decimali.format(biliardo.pos_y [ultima]));
	    inp_angolo.setText(notaz9Decimali.format
			       (RAD2DEG*Math.atan2(biliardo.vel_y[ultima],biliardo.vel_x[ultima])));
	    distanzaOra=biliardo.distPercorsa[biliardo.niter-1];
	    //areaDisegno.paintComponent(areaDisegno.getGraphics());
	}
	else if (e.getSource()== pulsInverti) {
	    int ultima=biliardo.niter-1;
	    inp_pos0x.setText( notaz9Decimali.format(biliardo.pos_x [ultima]));
	    inp_pos0y.setText( notaz9Decimali.format(biliardo.pos_y [ultima]));
	    double angolo;
	    angolo=RAD2DEG*Math.atan2(-biliardo.vel_y[ultima],-biliardo.vel_x[ultima]);
	    //angolo=180-angolo;
	    //if (angolo>180) angolo=360-angolo;
	    inp_angolo.setText(notaz9Decimali.format(angolo));
	    distanzaOra=biliardo.distPercorsa[biliardo.niter-1];
	    //areaDisegno.paintComponent(areaDisegno.getGraphics());
	}
	else if (e.getSource()== pulsScrivi && abilitaScrittura) {
		try {
		    biliardo.scriviTraiettoria
			  (notaz9Decimali, FILE_TRAIETTORIA, FILE_INFORMAZIONI);
		    JOptionPane.showMessageDialog
			(this,"Scritti file: "+FILE_TRAIETTORIA+" , "+FILE_INFORMAZIONI+"  e codifica.txt.",
			 "Biliardi e caos - Informazione", JOptionPane.INFORMATION_MESSAGE);
		}
		catch (java.io.IOException ex) {
		    JOptionPane.showMessageDialog
			(this,"Errore nella scrittura dei file con la traiettoria.",
			 "Biliardi e caos - Errore", JOptionPane.ERROR_MESSAGE);
		}
		catch (java.security.AccessControlException ex) {
		    JOptionPane.showMessageDialog
			(this,"Errore nella scrittura dei file con la traiettoria:\npermesso negato.",
			 "Biliardi e caos - Errore", JOptionPane.ERROR_MESSAGE);
		}
	}
    }


    /**
     * Funzione eseguita ogni volta che si trascina una barra di selezione
     */
    public void stateChanged(ChangeEvent e) {
	if (e.getSource()== selettVelocita) {
	    velocita=((double)selettVelocita.getValue())/SCALAVELOCITA;
	}
    }


    /**
     * L'animazione: ogni DT_ANIM millisecondi muovi la biglia
     */
    public void run() {
    	Thread me = Thread.currentThread();
	while(animThread==me) {
	  try { Thread.sleep(DT_ANIM); } catch (InterruptedException e) {};
	  if (animThread==me) {
	      // il tempo trascorso in secondi e' DT_ANIM/1000
	      distanzaOra=distanzaOra+(0.001*DT_ANIM)*velocita;
	      //System.out.println("q "+distanzaOra);
	      if (distanzaOra>biliardo.distPercorsa[biliardo.niter-1]) {
		  stopIfRunning(true);
		  distanzaOra=0;
	      }
	  } else { stopIfRunning(true); }
	  // In una precedente versione, a questo punto si chiamava:
	  //areaDisegno.paintComponent(areaDisegno.getGraphics());
	  // per ridisegnare il pannello. Ora il pannello si
	  // aggiorna automaticamente.
      }
    }


    /**
     * Arresta l'animazione se e' in corso, o falla partire se e' ferma
     */
    public void stopIfRunning(boolean running) {
	if (running) {
    	    if (animazioneInCorso) animThread=null;
    	} else {
    	    animThread=new Thread(this);
    	    animThread.start();
    	}
    	animazioneInCorso=!running;
      }
    

    /**
     * Crea un pannello "biliardi e caos" e apri una finestra per visualizzarlo
     */
    public static void main(String[] args) {
        JFrame f=new JFrame("Biliardi e caos: laboratorio numerico - versione "+VERSIONE);
        BiliardiECaos bec=new BiliardiECaos(true);
        f.getContentPane().add(bec);
        f.pack();
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setDefaultLookAndFeelDecorated(false);
	f.setResizable(false);
        f.setVisible(true);
    }


    /////////////////////////////////////////////////////////////////////
    //
    //                          CLASSI INTERNE
    //
    /////////////////////////////////////////////////////////////////////


    /********************************************************************
     * L'area in cui tracciare il moto della biglia.
     */
    class AreaDisegno extends JPanel implements Runnable {
	int dt_ridisegna=50; // 20 volte al secondo
        Color col_SFONDO=Color.BLACK;
        Color col_BORDO_BILIARDO=new Color(170,90,0);
        Color col_BILIARDO=new Color(0,160,0);
        Color col_BIGLIA=Color.YELLOW;
        Color col_TRAIETTORIA=Color.WHITE;
        Color col_ANIM_TRAIETTORIA=Color.CYAN;
        Color col_VECCHIA_TRAIETTORIA=new Color(0,250,0);
        Color col_TESTO=Color.WHITE;
	Image offScreen;
	Graphics goff;
	Thread disegnaThread;
	double scala;
	int raggioBiglia=6;
	int bordoBiliardo=25;
	//
	public AreaDisegno () {
	    this.setPreferredSize(new Dimension(2*DIMAREA_X+1,2*DIMAREA_Y+1));
	    this.setBackground(col_SFONDO);
	}
	//
	public void paintComponent(Graphics g) {
	    if (offScreen==null) offScreen=createImage(2*DIMAREA_X+1,2*DIMAREA_Y+1);
	    goff=offScreen.getGraphics();
	    paintOnGraphics(goff);
	    g.drawImage(offScreen,0,0,this);
	    // Dopo che l'hai disegnato la prima volta, avvia un thread che
	    // continuera' a ridisegnarlo.
	    if (disegnaThread==null) {
		disegnaThread=new Thread(this);
		disegnaThread.start();
	    }
	}
	//
	public void paintOnGraphics(Graphics g) {
	    //
	    // Usa la posizione in cui e' arrivato in questo momento
	    double distanzaOra_ = distanzaOra;
	    // Trova l'iterazione corrispondente
	    int iterazOra=0;
	    for (int i=0;i<biliardo.niter;i++)
		if (distanzaOra_>biliardo.distPercorsa[i])
		    iterazOra=i;
	    //System.out.println("--- "+iterazOra);
	    //
	    double posizOra_x;
	    double posizOra_y;
	    // Se c'e' un passo successivo, la biglia sara' sulla strada...
	    if (iterazOra<biliardo.niter-1) {
		// Quanto manca al passo successivo (in termini relativi)
		double scarto = (
				 distanzaOra_ - biliardo.distPercorsa[iterazOra]
				 )/(
				    biliardo.distPercorsa[iterazOra+1] - 
				    biliardo.distPercorsa[iterazOra]
				    );
		// Dov'e' la biglia, quindi?
		posizOra_x = biliardo.pos_x[iterazOra] * (1-scarto) +
		    biliardo.pos_x[iterazOra+1] * (scarto);
		posizOra_y = biliardo.pos_y[iterazOra] * (1-scarto) +
		    biliardo.pos_y[iterazOra+1] * (scarto);
	    }
	    // ...altrimenti esattamente su un rimbalzo:
	    else {
		posizOra_x=biliardo.pos_x[iterazOra];
		posizOra_y=biliardo.pos_y[iterazOra];
	    }
	    //
	    //System.out.println(""+iterazOra+"-"+distanzaOra_);
	    //
	    double max_x=0, max_y=0, scala_x, scala_y;
	    if (biliardo.forma==Biliardo.RETTANGOLO) {
		max_x=biliardo.metaLatoOrizz();
		max_y=biliardo.metaAltezza();
	    } else if (biliardo.forma==Biliardo.STADIO) {
		max_x=biliardo.metaAltezza()+biliardo.metaLatoOrizz();
		max_y=biliardo.metaAltezza();
	    }
	    scala_x=DIMAREA_X/max_x;
	    scala_y=DIMAREA_Y/max_y;
	    scala=((scala_x<scala_y)?scala_x:scala_y) / 1.30;
	    //
	    // Sfondo
	    super.paintComponent(g);
	    //
	    // Il biliardo
	    int ss=(int) (scala*biliardo.metaAltezza());
	    int ix=x2schermo(-biliardo.metaLatoOrizz());
	    int iy=y2schermo(biliardo.metaAltezza());
	    int lx=2*(DIMAREA_X-ix)+1;
	    int ly=2*(DIMAREA_Y-iy)+1;
	    int rb=raggioBiglia;
	    int bb=bordoBiliardo+raggioBiglia;
	    if (biliardo.forma==Biliardo.STADIO) {
		g.setColor(col_BORDO_BILIARDO);
		g.fillOval(    ix-ss-bb, iy-bb, ly+2*bb+1, ly+2*bb+1);
		g.fillOval( lx+ix-ss-bb, iy-bb, ly+2*bb+1, ly+2*bb+1);
		g.fillRect( ix, iy-bb, lx, ly+2*bb+1 );
		g.setColor(col_BILIARDO);
		g.fillOval(    ix-ss-rb, iy-rb, ly+2*rb+1, ly+2*rb+1);
		g.fillOval( lx+ix-ss-rb, iy-rb, ly+2*rb+1, ly+2*rb+1);
		g.fillRect( ix, iy-rb, lx, ly+2*rb+1 );
	    } else if (biliardo.forma==Biliardo.RETTANGOLO) {
		g.setColor(col_BORDO_BILIARDO);
		g.fillRect( ix-bb, iy-bb, lx+2*bb+1, ly+2*bb+1 );
		g.setColor(col_BILIARDO);
		g.fillRect( ix-rb, iy-rb, lx+2*rb+1, ly+2*rb+1 );
	    }
	    //
	    // La vecchia traiettoria, se esiste
	    if (vecchioBiliardo!=null) {
		g.setColor(col_VECCHIA_TRAIETTORIA);
		for (int iii=0;iii<vecchioBiliardo.niter-1;iii++)
		    g.drawLine( x2schermo(vecchioBiliardo.pos_x[iii  ]),
				y2schermo(vecchioBiliardo.pos_y[iii  ]),
				x2schermo(vecchioBiliardo.pos_x[iii+1]),
				y2schermo(vecchioBiliardo.pos_y[iii+1])  );
	    }
	    //
	    // La nuova traiettoria
	    if (!animazioneInCorso) {
		g.setColor(col_TRAIETTORIA);
		for (int iii=0;iii<biliardo.niter-1;iii++)
		    g.drawLine( x2schermo(biliardo.pos_x[iii  ]),
				y2schermo(biliardo.pos_y[iii  ]),
				x2schermo(biliardo.pos_x[iii+1]),
				y2schermo(biliardo.pos_y[iii+1])  );
	    }
	    //
	    if (animazioneInCorso) {
		// La traiettoria gia' percorsa durante l'animazione
		g.setColor(col_ANIM_TRAIETTORIA);
		for (int iii=0;iii<iterazOra;iii++)
		    g.drawLine( x2schermo(biliardo.pos_x[iii  ]),
				y2schermo(biliardo.pos_y[iii  ]),
				x2schermo(biliardo.pos_x[iii+1]),
				y2schermo(biliardo.pos_y[iii+1])  );
		//
		// L'ultimo segmento durante l'animazione
		g.drawLine( x2schermo(posizOra_x),
			    y2schermo(posizOra_y),
			    x2schermo(biliardo.pos_x[iterazOra  ]),
			    y2schermo(biliardo.pos_y[iterazOra  ])  );
	    }
	    //
	    // La posizione corrente della biglia
	    g.setColor(col_BIGLIA);
	    g.fillOval( x2schermo(posizOra_x)-raggioBiglia,
			y2schermo(posizOra_y)-raggioBiglia,
			2*raggioBiglia+1, 2*raggioBiglia+1);
	    //
	    if (false) { // Controllo di biliardo.eDentro(x,y)
		for (ix=-DIMAREA_X;ix<=DIMAREA_X;ix++) {
		    for (iy=-DIMAREA_Y;iy<=DIMAREA_Y;iy++) {
			double x=((double) ix) /scala;
			double y=((double) iy) /scala;
			Color col=(biliardo.eDentro(x,y)?Color.RED:Color.BLUE);
			g.setColor(col);
			g.fillOval(x2schermo(x),y2schermo(y),1,1);
		    }
		}
	    }
	    //
	    if (true) {
		g.setColor(col_TESTO);
		// Assi di riferimento x, y
		g.drawLine(5,2*DIMAREA_Y-5,50,2*DIMAREA_Y-5);
		g.drawString("x",50-7,2*DIMAREA_Y+1-5-5);
		g.drawLine(5,2*DIMAREA_Y-5,5,2*DIMAREA_Y-50);
		g.drawString("y",5+5,2*DIMAREA_Y+1-50+10);
		// Tacche lungo x
		for (int i=-1;i<=1;i++) {
		    //g.drawLine( x2schermo((double)i),0 ,
		    //            x2schermo((double)i),5  );
		    g.drawLine( x2schermo((double)i),2*DIMAREA_X   ,
				x2schermo((double)i),2*DIMAREA_X-5 );
		    g.drawString( ""+i, x2schermo((double)i)-5, 2*DIMAREA_Y-10 );
		}
		// Tacche lungo y
		for (int i=-1;i<=1;i++) {
		    g.drawLine( 0,              y2schermo((double)i) ,
				5,              y2schermo((double)i)  );
		    //g.drawLine( 2*DIMAREA_X+1,  y2schermo((double)i) ,
		    //            2*DIMAREA_X+1-5,y2schermo((double)i)  );
		    g.drawString( ""+i, 5+5,y2schermo((double)i)+4 );
		}
	    }
	    //
	}
	//
	/**
	 * L'animazione: ogni DT millisecondi ridisegna il pannello
	 */
	public void run() {
	    Thread me = Thread.currentThread();
	    while(disegnaThread==me) {
		try { Thread.sleep(dt_ridisegna); } catch (InterruptedException e) {};
		this.paintComponent(this.getGraphics());
	    }
	}
	//
	int x2schermo(double x) {
	    return (int) ( x*scala+DIMAREA_X+1);
	}
	//
	int y2schermo(double y) {
	    return (int) (-y*scala+DIMAREA_Y+1);
	}
    }


}////////////////////////////   FINE FILE   ///////////////////////////////
