import java.text.DecimalFormat;
import java.io.*;
//
public class Biliardo {
    //
    static double VELOCITA=1;
    static int STADIO=0;
    static int RETTANGOLO=1;
    static double MINLATORETT=0.1;
    static double MAXLATOORIZZ=10.0;
    static int MAXITER=10000;
    //
    int forma;
    int niter;
    /** Dimensione del lato orizzontale, dello stadio o del
     * rettangolo, in relazione alla dimensione verticale (diametro o
     * lato verticale) */
    double latoOrizz;
    double pos_x[], pos_y[];
    double vel_x[], vel_y[];
    /** Distanza percorsa dal punto iniziale */
    double distPercorsa[];
    //
    public Biliardo (int _forma, double _metaLatoOrizz, int _niter, double _pos0x, double _pos0y, double _angolo) {
        //
        // Copia i parametri del biliardo
	forma=_forma;
	if (! ((forma==STADIO)||(forma==RETTANGOLO)) ) forma=STADIO;
	latoOrizz=_metaLatoOrizz*2; // Lungo x il biliardo si estende da -metaLato a +metaLato
	if ((forma==RETTANGOLO)&&(latoOrizz<MINLATORETT)) latoOrizz=MINLATORETT;
	if (latoOrizz>MAXLATOORIZZ) latoOrizz=MAXLATOORIZZ;
        // Copia i parametri del calcolo
        if (_niter<0) _niter=-_niter;
        niter=_niter+1;
	if (niter>MAXITER) niter=MAXITER;
        //
        // Prepara lo spazio in memoria
        pos_x=new double[niter];
        pos_y=new double[niter];
        vel_x=new double[niter];
        vel_y=new double[niter];
        distPercorsa=new double[niter];
	//
        // Imposta le condizioni iniziali
        pos_x[0] = _pos0x;
        pos_y[0] = _pos0y;
	vel_x[0] = VELOCITA * Math.cos(_angolo);
	vel_y[0] = VELOCITA * Math.sin(_angolo);
	//
	// Calcola la traiettoria
	if (forma==STADIO) calcolaStadio();
	if (forma==RETTANGOLO) calcolaRettangolo();
	//
	// Calcola la distanza percorsa
	distPercorsa[0]=0.;
	for (int i=1;i<niter;i++)
	    distPercorsa[i] = distPercorsa[i-1] +
		Math.sqrt( Math.pow(pos_x[i]-pos_x[i-1],2)+
			   Math.pow(pos_y[i]-pos_y[i-1],2) );
    }


    /**
     * Restituisce il semi-lato orizzontale del biliardo.
     */
    public double metaLatoOrizz() {
	return latoOrizz/2;
    }
    /**
     * Restituisce la semi-altezza del biliardo.
     */
    public double metaAltezza() {
    	return 1.;
    }
    

    /** Controlla se un punto in (x,y) e' dentro il biliardo */
    public boolean eDentro(double x, double y) {
	double tolleranza=1.e-8;
	double ax=Math.abs(x);
	double ay=Math.abs(y);
	if (ay>1+tolleranza) return false;
	if (ax<=latoOrizz/2+tolleranza) return true;
	if (forma==STADIO)
	    if ( (ax-latoOrizz/2)*(ax-latoOrizz/2) + ay*ay <=1+2*tolleranza )
		return true;
	return false;
    }


    private void calcolaStadio() {
	//
	double vxn=1;
	double vyn=0;
	double xn=0;
	double yn=0;
	double el=latoOrizz;
	double x, y, vx, vy, xp, yp, tc, tcsp, tcdp;
	//
	for (int i=0;i<niter-1;i++) {
	    x=pos_x[i];
	    y=pos_y[i];
	    vx=vel_x[i];
	    vy=vel_y[i];
	    //
	    boolean collLato=false;
	    //
	    if ((vy!=0)&&(el>0)) { // possibilita' di collisione con i lati dritti
		//
		if (vy>0.0) { // possibile collisione col lato superiore
		    tc = (1 - y)/vy;
		    xp = x + vx * tc;
		    yp = 1;
		} else { // (vy <0) quindi possibile collisione col lato inferiore
		    tc = (-1 - y)/vy;
		    xp = x + vx * tc;
		    yp = -1;
		}
		//
		if((xp>=-el/2)&&(xp<=el/2)) { // si e' verificata la collisione
		    xn  =  xp;
		    yn  =  yp;
		    vxn =  vx;
		    vyn = -vy;
		    collLato = true;
		}
	    }
	    if (!collLato) {  // Deve verificarsi collisione con un lato circolare
		//               Determiniamo i possibili tempi di collisione
		//               imponendo che un punto sulla retta 
		//               in forma parametrica
		//               xn = x + vx * t
		//               yn = y + vy * t
		//               giaccia su uno o entrambi i cerchi di raggio 1
		//               centrati in -el/2 e +el/2
		//               Per ogni eventuale coppia di tempi su
		//               ciascun cerchio ci interessa il tempo
		//               positivo (nel futuro) massimo percio'
		//               e' sufficiente prendere la sola radice positiva
		//               nella soluzione dell' equazione di 2ndo grado 
		//
		double dettc_s= Math.pow((x+el/2)*vx + y*vy,2) - ((x+el/2)*(x+el/2) + y*y - 1);
		if (dettc_s>=0) { // intersezione con cerchio sinistra
		    tcsp = ( -((x+el/2)*vx + y*vy) + Math.sqrt( dettc_s ) );
		} else {
		    tcsp = 0;
		}
		//
		double dettc_d= Math.pow((x-el/2)*vx + y*vy,2) - ((x-el/2)*(x-el/2) + y*y - 1);
		if (dettc_d>= 0) { //intersezione con cerchio destra
		    tcdp = ( -((x-el/2)*vx + y*vy) + Math.sqrt( dettc_d ) );
		} else {
		    tcdp = 0;
		}
		//
		// Tra i 2 possibili tempi di collisione ci interessa
		// quello massimo
		tc=(tcdp>tcsp)?tcdp:tcsp;
		//
		// nuove posizioni
		xn   = x + vx * tc;
		yn   = y + vy * tc;
		//
		// nuove velocita'
		if (xn<=-el/2) { // semicerchio sinistro
		    vxn = (yn*yn - Math.pow(xn + el/2,2))*vx - 2*(xn + el/2)*yn*vy;
		    vyn = -2*(xn + el/2)*yn*vx + (Math.pow(xn + el/2,2) - yn*yn)*vy;
		} else if (xn>=el/2) { // semicerchio destro
		    vxn = (yn*yn - Math.pow(xn - el/2,2))*vx - 2*(xn - el/2)*yn*vy;
		    vyn = -2*(xn - el/2)*yn*vx + (Math.pow(xn - el/2,2) - yn*yn)*vy;
		} else {
		    System.out.println("errore: nessuna collisione:"+i+"\n");
		}
		//
		// ri-impone la condizione di modulo unitario della
		// velocita' per prevenire instabilita' da arrotondamento
		double vmod = Math.sqrt( vxn*vxn + vyn*vyn );
		vxn = vxn/vmod;
		vyn = vyn/vmod;
	    }
	    //
	    pos_x[i+1]=xn;
	    pos_y[i+1]=yn;
	    vel_x[i+1]=vxn;
	    vel_y[i+1]=vyn;
	}
    }



    private void calcolaRettangolo() {
	//
	double vxn=1;
	double vyn=0;
	double xn=0;
	double yn=0;
	double el=latoOrizz;
	double x, y, vx, vy, xp, yp, tc, tcsp, tcdp;
	//
	for (int i=0;i<niter-1;i++) {
	    //
	    x=pos_x[i];
	    y=pos_y[i];
	    vx=vel_x[i];
	    vy=vel_y[i];
	    //
	    boolean coll_lato = false;
	    //
	    if(vy != 0 && el != 0 ) { // possible collision with horizontal sides
		//
		if( vy > 0.0) { //       possible collision  with the upper side
		    tc = (1 - y)/vy;
		    xp = x + vx * tc;
		    yp = 1;
		} else { //  (vy <0) then possible coll.  with the lower side
		    tc = (-1 - y)/vy;
		    xp = x + vx * tc;
		    yp = -1;
		}
		//
		if( xp >= -el/2 &&  xp <= el/2 ) { // collision
		    xn  =  xp;
		    yn  =  yp;
		    vxn =  vx;
		    vyn = -vy;
		    coll_lato = true;
		}
	    }
	    //
	    if( ! coll_lato ) { // thus collision with a vertical side 
		//
		if( vx > 0.0 ) { //      possible collision with the right side
		    tc = (el/2 - x)/vx;
		    xp = el/2;
		    yp = y + vy * tc;
		} else { // (vx <0) thus coll.  with the left side
		    tc = (-el/2 - x)/vx;
		    xp = -el/2;
		    yp = y + vy * tc;
		}
		//
		if( yp >= -1 &&  yp <= 1 ) { // collision happened
		    xn  =  xp;
		    yn  =  yp;
		    vxn = -vx;
		    vyn =  vy;
		}
	    }
	    //
	    pos_x[i+1]=xn;
	    pos_y[i+1]=yn;
	    vel_x[i+1]=vxn;
	    vel_y[i+1]=vyn;
	}
    }




    public void scriviTraiettoria
        (DecimalFormat fmt, String fileTraiettoria, String fileInformazioni)
        throws java.io.IOException
    {
        FileWriter FW;
	//
	if (fileTraiettoria!=null) {
	    FW=new FileWriter(fileTraiettoria);
	    for (int i=0;i<niter;i++) {
		FW.write( i                   +"\t"+
			  fmt.format(pos_x[i])+"\t"+
			  fmt.format(pos_y[i])+"\t"+
			  fmt.format(vel_x[i])+"\t"+
			  fmt.format(vel_y[i])+"\t"+"\n" );
	    }
	    FW.close();
        }
	//
	if (fileInformazioni!=null) {
	    FW=new FileWriter(fileInformazioni);
	    FW.write("# Descrizione della traiettoria contenuta nel file ");
	    FW.write(fileTraiettoria+":\n");
	    FW.write("#\n# Il file contiene 5 colonne. Nell'ordine:\n");
	    FW.write("#  1) l'indice di iterazione\n");
	    FW.write("#  2) posizione componente x\n");
	    FW.write("#  3) posizione componente y\n");
	    FW.write("#  4) velocita' componente x\n");
	    FW.write("#  5) velocita' componente y\n");
	    FW.write("#\n# La meta'-lato orizzontale del biliardo e': "+fmt.format(metaLatoOrizz())+" ;\n");
	    FW.write("#  Per disegnare il biliardo, di tipo "+((forma==STADIO)?"STADIO":"")+((forma==RETTANGOLO)?"RETTANGOLO":"")+", unire i punti che segunono:\n\n");
	    if (forma==STADIO) {
		for (int ic=0;ic<=100;ic++)
		    FW.write( fmt.format(+latoOrizz/2+Math.sin(ic*Math.PI/100)) +" "+
			      fmt.format(+Math.cos(ic*Math.PI/100))             +"\n");
		for (int ic=0;ic<=100;ic++)
		    FW.write( fmt.format(-latoOrizz/2-Math.sin(ic*Math.PI/100)) +" "+
			      fmt.format(-Math.cos(ic*Math.PI/100))             +"\n");
	    } else if (forma==RETTANGOLO) {
		FW.write(fmt.format(+latoOrizz/2)+" "+fmt.format(+1)+"\n");
		FW.write(fmt.format(-latoOrizz/2)+" "+fmt.format(+1)+"\n");
		FW.write(fmt.format(-latoOrizz/2)+" "+fmt.format(-1)+"\n");
		FW.write(fmt.format(+latoOrizz/2)+" "+fmt.format(-1)+"\n");
	    }
	    FW.write(fmt.format(+latoOrizz/2)+" "+fmt.format(+1));
	    FW.close();
	}

 	if (fileTraiettoria!=null) {
            FW=new FileWriter("codifica.txt");
            for (int i=0;i<niter;i++) {
                FW.write( i +"\t"+ ((pos_x[i]>0)?1:0) +"\n" );
            }            FW.close();        }
    }
    //
}
