//
//      Lab7_8: TMS320F28335
//      (c) Frank Bormann
//
//###########################################################################
//
// FILE:	Lab7_8.c
// 
// TITLE:	DSP28335ControlCARD; ePWM1A 1KHz output
//			variable pulse width independently 
//			ePWM1A controlled by CMPA
//			ePWM1B controlled by CMPB
//			Trip - Zone Alarm
//			solution file for Lab7_8
//###########################################################################
//  Ver | dd mmm yyyy | Who  | Description of changes
// =====|=============|======|===============================================
//  3.0 | 15 Apr 2009 | F.B. | Lab7_8 for F28335; 
//  3.1 | 11 Nov 2009 | F.B  | Lab7_8 for F28335 and PE revision 5
//###########################################################################
#include "DSP2833x_Device.h"

// external function prototypes
extern void InitSysCtrl(void);
extern void InitPieCtrl(void);
extern void InitPieVectTable(void);
extern void InitCpuTimers(void);
extern void ConfigCpuTimer(struct CPUTIMER_VARS *, float, float);


// Prototype statements for functions found within this file.
void Gpio_select(void);
void Setup_ePWM1(void);
interrupt void cpu_timer0_isr(void);
interrupt void ePWM1_TZ_isr(void);

//###########################################################################
//						main code									
//###########################################################################
void main(void)
{
	int counter=0;	// binary counter for digital output

	InitSysCtrl();	// Basic Core Init from DSP2833x_SysCtrl.c

	EALLOW;
   	SysCtrlRegs.WDCR= 0x00AF;	// Re-enable the watchdog 
   	EDIS;			// 0x00AF  to NOT disable the Watchdog, Prescaler = 64

	DINT;				// Disable all interrupts
	
	Gpio_select();		// GPIO9, GPIO11, GPIO34 and GPIO49 as output
					    // to 4 LEDs at Peripheral Explorer Board

	Setup_ePWM1();		// init of ePWM1A

	InitPieCtrl();		// basic setup of PIE table; from DSP2833x_PieCtrl.c
	
	InitPieVectTable();	// default ISR's in PIE

	EALLOW;
	PieVectTable.TINT0 = &cpu_timer0_isr;
	PieVectTable.EPWM1_TZINT = &ePWM1_TZ_isr;
	EDIS;

	InitCpuTimers();	// basic setup CPU Timer0, 1 and 2

	ConfigCpuTimer(&CpuTimer0,150,100000);

	PieCtrlRegs.PIEIER1.bit.INTx7 = 1;	// CPU - Timer 0
	PieCtrlRegs.PIEIER2.bit.INTx1 = 1;	// ePWM1-TZ

	IER |=3;			// enable INT1 and INT2

	EINT;
	ERTM;

	CpuTimer0Regs.TCR.bit.TSS = 0;	// start timer0

	while(1)
	{    
	  		while(CpuTimer0.InterruptCount == 0);
			CpuTimer0.InterruptCount = 0;
			
			EALLOW;
			SysCtrlRegs.WDKEY = 0x55;	// service WD #1
			EDIS;

	  		counter++;
			
	}
} 

void Gpio_select(void)
{
	EALLOW;
	GpioCtrlRegs.GPAMUX1.all = 0;		// GPIO15 ... GPIO0 = General Puropse I/O
	GpioCtrlRegs.GPAMUX1.bit.GPIO0 = 1;	// ePWM1A active
	GpioCtrlRegs.GPAMUX1.bit.GPIO1 = 1;	// ePWM1B active

	GpioCtrlRegs.GPAMUX2.all = 0;		// GPIO31 ... GPIO16 = General Purpose I/O
	GpioCtrlRegs.GPAMUX2.bit.GPIO17 = 3; // GPIO17 as /TZ6
	GpioCtrlRegs.GPBMUX1.all = 0;		// GPIO47 ... GPIO32 = General Purpose I/O
	GpioCtrlRegs.GPBMUX2.all = 0;		// GPIO63 ... GPIO48 = General Purpose I/O
	GpioCtrlRegs.GPCMUX1.all = 0;		// GPIO79 ... GPIO64 = General Purpose I/O
	GpioCtrlRegs.GPCMUX2.all = 0;		// GPIO87 ... GPIO80 = General Purpose I/O
	 
	GpioCtrlRegs.GPADIR.all = 0;
	GpioCtrlRegs.GPADIR.bit.GPIO9 = 1;	// peripheral explorer: LED LD1 at GPIO9
	GpioCtrlRegs.GPADIR.bit.GPIO11 = 1;	// peripheral explorer: LED LD2 at GPIO11


	GpioCtrlRegs.GPBDIR.all = 0;		// GPIO63-32 as inputs
	GpioCtrlRegs.GPBDIR.bit.GPIO34 = 1;	// peripheral explorer: LED LD3 at GPIO34
	GpioCtrlRegs.GPBDIR.bit.GPIO49 = 1; // peripheral explorer: LED LD4 at GPIO49
	GpioCtrlRegs.GPCDIR.all = 0;		// GPIO87-64 as inputs
	EDIS;
}  

void Setup_ePWM1(void)
{
	EPwm1Regs.TBCTL.bit.CLKDIV =  0;	// CLKDIV = 1		
	EPwm1Regs.TBCTL.bit.HSPCLKDIV = 1;	// HSPCLKDIV = 2
	EPwm1Regs.TBCTL.bit.CTRMODE = 2;	// up - down mode

	EPwm1Regs.AQCTLA.all = 0x0060;		// set ePWM1A on CMPA up
										// clear ePWM1A on CMPA down
	EPwm1Regs.AQCTLB.all = 0x0600;		// set ePWM1B on CMPB up
										// clear ePWM1B on CMPB down

	EPwm1Regs.TBPRD = 37500;			// 1KHz - PWM signal
	EPwm1Regs.CMPA.half.CMPA = EPwm1Regs.TBPRD / 2;	// 50% duty cycle ePWM1A
	EPwm1Regs.CMPB  = 	EPwm1Regs.TBPRD / 2;		// 50% duty cycle ePWM1B
	EALLOW;								
	EPwm1Regs.TZCTL.bit.TZA = 2;		// force ePWM1A to zero
	EPwm1Regs.TZCTL.bit.TZB = 2;		// force ePWM1B to zero
	//EPwm1Regs.TZSEL.bit.OSHT6 = 1;	// select TZ6 as one shot over current source
	EPwm1Regs.TZSEL.bit.CBC6 = 1;		// now TZ6 as cycle by cycle over current
	EPwm1Regs.TZEINT.bit.CBC = 1;		// enable CBC interrupt
	EDIS;
} 

interrupt void cpu_timer0_isr(void)
{
	CpuTimer0.InterruptCount++;
	EALLOW;
	SysCtrlRegs.WDKEY = 0xAA;	// service WD #2
	EDIS;
	
	GpioDataRegs.GPATOGGLE.bit.GPIO11 = 1;

	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
}

interrupt void ePWM1_TZ_isr(void)
{
	EALLOW;
	EPwm1Regs.TZCLR.bit.CBC = 1;
	EPwm1Regs.TZCLR.bit.INT = 1;	// reset interrupt flags
	SysCtrlRegs.WDKEY = 0x55;		// service WD #1
	EDIS;
	GpioDataRegs.GPATOGGLE.bit.GPIO9 = 1;	// toggle LED at GPIO9
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;
}
//===========================================================================
// End of SourceCode.
//===========================================================================
