//
//      Lab7_10: TMS320F28027
//      (c) Frank Bormann
//
//###########################################################################
//
// FILE:	Lab7_10.c
// 
// TITLE:	DSP28027_USB_Stick; ePWM1A 1KHz square wave output
//			and measurement with eCAP1
//			solution file for Lab7_10
//###########################################################################
//  Ver | dd mmm yyyy | Who  | Description of changes
// =====|=============|======|===============================================
//  1.0 | 01 Jun 2009 | F.B. | Lab7_10 for F28027; 
//###########################################################################
#include "DSP2802x_Device.h"

// external function prototypes
extern void InitSysCtrl(void);
extern void InitPieVectTable(void);
extern void InitPieCtrl(void);
extern void InitCpuTimers(void);
extern void ConfigCpuTimer(struct CPUTIMER_VARS *, float, float);

// Prototype statements for functions found within this file.
void Gpio_Select(void);
void Setup_ePWM1A(void);
void Setup_eCAP1(void);
interrupt void cpu_timer0_isr(void);
interrupt void eCAP1_isr(void);

// Global Variables
Uint32 PWM_Duty;
Uint32 PWM_Period;

//###########################################################################
//						main code									
//###########################################################################
void main(void)
{
	InitSysCtrl();	// Basic Core Init from DSP2802x_SysCtrl.c
	 

	EALLOW;
   	SysCtrlRegs.WDCR= 0x00AF;	// Re-enable the watchdog 
   	EDIS;			// 0x00AF  to NOT disable the Watchdog, Prescaler = 64

	DINT;				// Disable all interrupts
	
	Gpio_Select();		// GPIO34 as output (LED) & EPWM1A

	Setup_ePWM1A();		// init of ePWM1A

	Setup_eCAP1();		// init  eCAP1

	InitPieCtrl();		// basic setup of PIE table; from DSP2833x_PieCtrl.c
	
	InitPieVectTable();	// default ISR's in PIE

	EALLOW;
	PieVectTable.TINT0 = &cpu_timer0_isr;
	PieVectTable.ECAP1_INT= &eCAP1_isr;
	EDIS;

	InitCpuTimers();	// basic setup CPU Timer0, 1 and 2

	ConfigCpuTimer(&CpuTimer0,60,100000);

	PieCtrlRegs.PIEIER1.bit.INTx7 = 1;	// Enable CPU Timer 0 INT
	PieCtrlRegs.PIEIER4.bit.INTx1 = 1;	// Enable ECAP1_INT in PIE group 4
	IER |= 0x0009;						// Enable INT4 and INT1


	EINT;
	ERTM;

	CpuTimer0Regs.TCR.bit.TSS = 0;	// start timer0

	while(1)
	{    
	  		EALLOW;
			SysCtrlRegs.WDKEY = 0x55;	// service WD #1
			EDIS;
	}
} 

void Gpio_Select(void)
{
	EALLOW;
	GpioCtrlRegs.GPAMUX1.all = 0;		// GPIO15 ... GPIO0 = General Puropse I/O
	GpioCtrlRegs.GPAMUX1.bit.GPIO0 = 1;	// ePWM1A active
	GpioCtrlRegs.GPAMUX1.bit.GPIO5 = 3; // eCAP1 active
	GpioCtrlRegs.GPAMUX2.all = 0;		// GPIO31 ... GPIO16 = General Purpose I/O
	GpioCtrlRegs.GPBMUX1.all = 0;		// GPIO38 ... GPIO32 = General Purpose I/O
	GpioCtrlRegs.GPADIR.all = 0;
	GpioCtrlRegs.GPBDIR.all = 0;		// GPIO38 ... GPIO32 as inputs
	GpioCtrlRegs.GPBDIR.bit.GPIO34 = 1;	// GPIO34 as output (LED LD2 at 28027stick)
	EDIS;
}  

void Setup_ePWM1A(void)
{
	EPwm1Regs.TBCTL.all = 0;			// default status
	EPwm1Regs.TBCTL.bit.CLKDIV =  0;	// CLKDIV = 1		
	EPwm1Regs.TBCTL.bit.HSPCLKDIV = 0;	// HSPCLKDIV = 1
	EPwm1Regs.TBCTL.bit.CTRMODE = 2;	// up - down mode

	EPwm1Regs.AQCTLA.all = 0x0060;		// set ePWM1A on CMPA up
										// clear ePWM1A on CMPA down

	EPwm1Regs.TBPRD = 30000;	// 1KHz - PWM signal
								//  TBPRD = fcpu / (2*fPWM * CLKDIV * HSPCLKDIV)
								//  TPPRD = 60 MHz / (2 * 1KHz * 1 * 1) = 30000
	EPwm1Regs.CMPA.half.CMPA  = 15000;		// 50% duty cycle 
} 

interrupt void cpu_timer0_isr(void)
{
	EALLOW;
	SysCtrlRegs.WDKEY = 0xAA;	// service WD #2
	EDIS;
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
}

void Setup_eCAP1(void)
{
//---------------------------------------------------------------------
//--- Configure eCAP1 unit for capture                        
//---------------------------------------------------------------------
	ECap1Regs.ECEINT.all = 0;					// Disable all eCAP interrupts
	ECap1Regs.ECCTL1.bit.CAPLDEN = 0;			// Disabled loading of capture results
	ECap1Regs.ECCTL2.bit.TSCTRSTOP = 0;			// Stop the counter

	ECap1Regs.TSCTR = 0;						// Clear the counter
	ECap1Regs.CTRPHS = 0;						// Clear the counter phase register

	ECap1Regs.ECCTL2.all = 0x0096;				// ECAP control register 2
// bit 15-11     00000:  reserved
// bit 10        0:      APWMPOL, don't care
// bit 9         0:      CAP/APWM, 0 = capture mode, 1 = APWM mode
// bit 8         0:      SWSYNC, 0 = no action (no s/w synch)
// bit 7-6       10:     SYNCO_SEL, 10 = disable sync out signal
// bit 5         0:      SYNCI_EN, 0 = disable Sync-In
// bit 4         1:      TSCTRSTOP, 1 = enable counter
// bit 3         0:      RE-ARM, 0 = don't re-arm, 1 = re-arm
// bit 2-1       11:     STOP_WRAP, 11 = wrap after 4 captures
// bit 0         0:      CONT/ONESHT, 0 = continuous mode

	ECap1Regs.ECCTL1.all = 0x01C4;				// ECAP control register 1
// bit 15-14     00:     FREE/SOFT, 00 = stop TSCTR immediately
// bit 13-9      00000:  PRESCALE, 00000 = divide by 1
// bit 8         1:      CAPLDEN, 1 = enable capture results load
// bit 7         1:      CTRRST4, 1 = reset counter on CAP4 event
// bit 6         1:      CAP4POL, 0 = rising edge, 1 = falling edge
// bit 5         0:      CTRRST3, 0 = do not reset counter on CAP3 event
// bit 4         0:      CAP3POL, 0 = rising edge, 1 = falling edge
// bit 3         0:      CTRRST2, 0 = do not reset counter on CAP2 event
// bit 2         1:      CAP2POL, 0 = rising edge, 1 = falling edge
// bit 1         0:      CTRRST1, 0 = do not reset counter on CAP1 event
// bit 0         0:      CAP1POL, 0 = rising edge, 1 = falling edge

	ECap1Regs.ECEINT.all = 0x0008;				// Enable desired eCAP interrupts
// bit 15-8      0's:    reserved
// bit 7         0:      CTR=CMP, 0 = compare interrupt disabled
// bit 6         0:      CTR=PRD, 0 = period interrupt disabled
// bit 5         0:      CTROVF, 0 = overflow interrupt disabled
// bit 4         0:      CEVT4, 0 = event 4 interrupt disabled
// bit 3         1:      CEVT3, 1 = event 3 interrupt enabled
// bit 2         0:      CEVT2, 0 = event 2 interrupt disabled
// bit 1         0:      CEVT1, 0 = event 1 interrupt disabled
// bit 0         0:      reserved
	
} // end InitECap()

interrupt void eCAP1_isr(void)
{
	ECap1Regs.ECCLR.bit.INT = 1;				// Clear the ECAP1 interrupt flag
	ECap1Regs.ECCLR.bit.CEVT3 = 1;				// Clear the CEVT3 flag

	// Calculate the PWM duty period (rising edge to falling edge)
	PWM_Duty = (int32)ECap1Regs.CAP2 - (int32)ECap1Regs.CAP1;

	// Calculate the PWM period (rising edge to rising edge)
	PWM_Period = (int32)ECap1Regs.CAP3 - (int32)ECap1Regs.CAP1;

	PieCtrlRegs.PIEACK.all = PIEACK_GROUP4;	// Must acknowledge the PIE group 4
}

//===========================================================================
// End of SourceCode.
//===========================================================================
