//
//      Lab7_2: TMS320F28027
//      (c) Frank Bormann
//
//###########################################################################
//
// FILE:	Lab7_2.c
// 
// TITLE:	DSP28027_USB_Stick; 
//			3 phase signal system 
//			phase shifted 1KHz output at ePWM1A, ePWM2A and ePWM3A
//			solution file for Lab7_2
//###########################################################################
//  Ver | dd mmm yyyy | Who  | Description of changes
// =====|=============|======|===============================================
//  1.0 | 01 Jun 2009 | F.B. | Lab7_2 for F28027; 
//###########################################################################
#include "DSP2802x_Device.h"

// external function prototypes
extern void InitSysCtrl(void);

// Prototype statements for functions found within this file.
void Gpio_select(void);
void Setup_ePWM(void);

//###########################################################################
//						main code									
//###########################################################################
void main(void)
{
	InitSysCtrl();	// Basic Core Init from DSP2802x_SysCtrl.c

	EALLOW;
   	SysCtrlRegs.WDCR= 0x00AF;	// Re-enable the watchdog 
   	EDIS;			// 0x00AF  to NOT disable the Watchdog, Prescaler = 64

	DINT;				// Disable all interrupts
	
	Gpio_select();		// GPIO34 = LD2; ePWM1A,ePWM2A, ePWM3A

	Setup_ePWM();		// init of ePWM

	while(1)
	{    
	  	EALLOW;
		SysCtrlRegs.WDKEY = 0x55;	// service WD #1
		SysCtrlRegs.WDKEY = 0xAA;	// service WD #2
		EDIS;
	}
} 

void Gpio_select(void)
{
	EALLOW;
	GpioCtrlRegs.GPAMUX1.all = 0;		// GPIO15 ... GPIO0 = General Puropse I/O
	GpioCtrlRegs.GPAMUX1.bit.GPIO0 = 1;	// ePWM1A active
	GpioCtrlRegs.GPAMUX1.bit.GPIO2 = 1;	// ePWM2A active
	GpioCtrlRegs.GPAMUX1.bit.GPIO4 = 1;	// ePWM3A active

	GpioCtrlRegs.GPAMUX2.all = 0;		// GPIO31 ... GPIO16 = General Purpose I/O
	GpioCtrlRegs.GPBMUX1.all = 0;		// GPIO38 ... GPIO32 = General Purpose I/O
		 
	GpioCtrlRegs.GPADIR.all = 0;

	GpioCtrlRegs.GPBDIR.all = 0;		// GPIO38-32 as inputs
	GpioCtrlRegs.GPBDIR.bit.GPIO34 = 1;	// GPIO34 as output (LED LD2 at 28027stick)
	EDIS;
}  

void Setup_ePWM(void)
{
	EPwm1Regs.TBCTL.all = 0;
	EPwm1Regs.TBCTL.bit.CLKDIV =  0;	// CLKDIV = 1		
	EPwm1Regs.TBCTL.bit.HSPCLKDIV = 0;	// HSPCLKDIV = 1
	EPwm1Regs.TBCTL.bit.CTRMODE = 2;	// up - down mode
	EPwm1Regs.AQCTLA.all = 0x0006;		// ZRO = set, PRD = clear
	EPwm1Regs.TBPRD = 30000;			// 1KHz - PWM signal

	EPwm2Regs.TBCTL.all = 0;
	EPwm2Regs.TBCTL.bit.CLKDIV =  0;	// CLKDIV = 1		
	EPwm2Regs.TBCTL.bit.HSPCLKDIV = 0;	// HSPCLKDIV = 1
	EPwm2Regs.TBCTL.bit.CTRMODE = 2;	// up - down mode
	EPwm2Regs.AQCTLA.all = 0x0006;		// ZRO = set, PRD = clear
	EPwm2Regs.TBPRD = 30000;			// 1KHz - PWM signal

	EPwm3Regs.TBCTL.all = 0;
	EPwm3Regs.TBCTL.bit.CLKDIV =  0;	// CLKDIV = 1		
	EPwm3Regs.TBCTL.bit.HSPCLKDIV = 0;	// HSPCLKDIV = 1
	EPwm3Regs.TBCTL.bit.CTRMODE = 2;	// up - down mode
	EPwm3Regs.AQCTLA.all = 0x0006;		// ZRO = set, PRD = clear
	EPwm3Regs.TBPRD = 30000;			// 1KHz - PWM signal
} 

//===========================================================================
// End of SourceCode.
//===========================================================================
