//
//      Lab7_4: TMS320F28027
//      (c) Frank Bormann
//
//###########################################################################
//
// FILE:	Lab7_4.c
// 
// TITLE:	DSP28027_USB_Stick; ePWM1A 1KHz square wave output
//			complementary signal at ePWM1B
//			Duty cycle between 0 and 100%; changed every 100 ms
//			solution file for Lab7_4
//###########################################################################
//  Ver | dd mmm yyyy | Who  | Description of changes
// =====|=============|======|===============================================
//  1.0 | 01 Jun 2009 | F.B. | Lab7_4 for F28027; 
//###########################################################################
#include "DSP2802x_Device.h"

// external function prototypes
extern void InitSysCtrl(void);
extern void InitPieVectTable(void);
extern void InitPieCtrl(void);
extern void InitCpuTimers(void);
extern void ConfigCpuTimer(struct CPUTIMER_VARS *, float, float);

// Prototype statements for functions found within this file.
void Gpio_Select(void);
void Setup_ePWM1A(void);
interrupt void cpu_timer0_isr(void);

//###########################################################################
//						main code									
//###########################################################################
void main(void)
{
	InitSysCtrl();	// Basic Core Init from DSP2802x_SysCtrl.c
	 

	EALLOW;
   	SysCtrlRegs.WDCR= 0x00AF;	// Re-enable the watchdog 
   	EDIS;			// 0x00AF  to NOT disable the Watchdog, Prescaler = 64

	DINT;				// Disable all interrupts
	
	Gpio_Select();		// GPIO34 as output (LED) & EPWM1A

	Setup_ePWM1A();		// init of ePWM1A

	InitPieCtrl();		// basic setup of PIE table; from DSP2833x_PieCtrl.c
	
	InitPieVectTable();	// default ISR's in PIE

	EALLOW;
	PieVectTable.TINT0 = &cpu_timer0_isr;
	EDIS;

	InitCpuTimers();	// basic setup CPU Timer0, 1 and 2

	ConfigCpuTimer(&CpuTimer0,60,100);

	PieCtrlRegs.PIEIER1.bit.INTx7 = 1;

	IER |=1;

	EINT;
	ERTM;

	CpuTimer0Regs.TCR.bit.TSS = 0;	// start timer0

	while(1)
	{    
	  		EALLOW;
			SysCtrlRegs.WDKEY = 0x55;	// service WD #1
			EDIS;
	}
} 

void Gpio_Select(void)
{
	EALLOW;
	GpioCtrlRegs.GPAMUX1.all = 0;		// GPIO15 ... GPIO0 = General Puropse I/O
	GpioCtrlRegs.GPAMUX1.bit.GPIO0 = 1;	// ePWM1A active
	GpioCtrlRegs.GPAMUX1.bit.GPIO1 = 1;	// ePWM1B active
	GpioCtrlRegs.GPAMUX2.all = 0;		// GPIO31 ... GPIO16 = General Purpose I/O
	GpioCtrlRegs.GPBMUX1.all = 0;		// GPIO38 ... GPIO32 = General Purpose I/O
	GpioCtrlRegs.GPADIR.all = 0;
	GpioCtrlRegs.GPBDIR.all = 0;		// GPIO38-32 as inputs
	GpioCtrlRegs.GPBDIR.bit.GPIO34 = 1;	// GPIO34 as output (LED LD2 at 28027stick)
	EDIS;
}  

void Setup_ePWM1A(void)
{
	EPwm1Regs.TBCTL.all = 0;			// default status
	EPwm1Regs.TBCTL.bit.CLKDIV =  0;	// CLKDIV = 1		
	EPwm1Regs.TBCTL.bit.HSPCLKDIV = 0;	// HSPCLKDIV = 1
	EPwm1Regs.TBCTL.bit.CTRMODE = 2;	// up - down mode

	EPwm1Regs.AQCTLA.all = 0x0060;		// set ePWM1A on CMPA up
										// clear ePWM1A on CMPA down
										
	EPwm1Regs.AQCTLB.all = 0x0090;		// clear ePWM1B	on CMPA up
										// set 	 ePWM1B on CMPA down

	EPwm1Regs.TBPRD = 30000;	// 1KHz - PWM signal
								//  TBPRD = fcpu / (2*fPWM * CLKDIV * HSPCLKDIV)
								//  TPPRD = 60 MHz / (2 * 1KHz * 1 * 1) = 30000
	EPwm1Regs.CMPA.half.CMPA  = 0;		// 100% duty cycle first
} 

interrupt void cpu_timer0_isr(void)
{
	static int up_down = 1;
	EALLOW;
	SysCtrlRegs.WDKEY = 0xAA;	// service WD #2
	EDIS;
	if(up_down)
	{
		if(EPwm1Regs.CMPA.half.CMPA < EPwm1Regs.TBPRD) EPwm1Regs.CMPA.half.CMPA++;
		else up_down = 0;
	}
	else
	{
		if(EPwm1Regs.CMPA.half.CMPA > 0) EPwm1Regs.CMPA.half.CMPA--;
		else up_down = 1;
	}
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
}
	//===========================================================================
// End of SourceCode.
//===========================================================================
