//
//      Lab7_8: TMS320F28027
//      (c) Frank Bormann
//
//###########################################################################
//
// FILE:	Lab7_8.c
// 
// TITLE:	DSP28027_USB_Stick; ePWM1A 1KHz square wave output
//			variable pulse width independently 
//			ePWM1A controlled by CMPA
//			ePWM1B controlled by CMPB
//			Trip - Zone Alarm
//			solution file for Lab7_8
//###########################################################################
//  Ver | dd mmm yyyy | Who  | Description of changes
// =====|=============|======|===============================================
//  1.0 | 01 Jun 2009 | F.B. | Lab7_8 for F28027; 
//###########################################################################
#include "DSP2802x_Device.h"

// external function prototypes
extern void InitSysCtrl(void);
extern void InitPieVectTable(void);
extern void InitPieCtrl(void);
extern void InitCpuTimers(void);
extern void ConfigCpuTimer(struct CPUTIMER_VARS *, float, float);

// Prototype statements for functions found within this file.
void Gpio_Select(void);
void Setup_ePWM1A(void);
interrupt void cpu_timer0_isr(void);
interrupt void ePWM1_TZ_isr(void);

//###########################################################################
//						main code									
//###########################################################################
void main(void)
{
	InitSysCtrl();	// Basic Core Init from DSP2802x_SysCtrl.c
	 

	EALLOW;
   	SysCtrlRegs.WDCR= 0x00AF;	// Re-enable the watchdog 
   	EDIS;			// 0x00AF  to NOT disable the Watchdog, Prescaler = 64

	DINT;				// Disable all interrupts
	
	Gpio_Select();		// GPIO34 as output (LED) & EPWM1A

	Setup_ePWM1A();		// init of ePWM1A

	InitPieCtrl();		// basic setup of PIE table; from DSP2833x_PieCtrl.c
	
	InitPieVectTable();	// default ISR's in PIE

	EALLOW;
	PieVectTable.TINT0 = &cpu_timer0_isr;
	PieVectTable.EPWM1_TZINT = &ePWM1_TZ_isr;
	EDIS;

	InitCpuTimers();	// basic setup CPU Timer0, 1 and 2

	ConfigCpuTimer(&CpuTimer0,60,200000);

	PieCtrlRegs.PIEIER1.bit.INTx7 = 1;	// Timer 0
	PieCtrlRegs.PIEIER2.bit.INTx1 = 1;	// TZINT for ePWM1

	IER |=3;

	EINT;
	ERTM;

	CpuTimer0Regs.TCR.bit.TSS = 0;	// start timer0

	while(1)
	{    
	  		EALLOW;
			SysCtrlRegs.WDKEY = 0x55;	// service WD #1
			EDIS;
	}
} 

void Gpio_Select(void)
{
	EALLOW;
	GpioCtrlRegs.GPAMUX1.all = 0;		// GPIO15 ... GPIO0 = General Puropse I/O
	GpioCtrlRegs.GPAMUX1.bit.GPIO0 = 1;	// ePWM1A active
	GpioCtrlRegs.GPAMUX1.bit.GPIO1 = 1;	// ePWM1B active
	GpioCtrlRegs.GPAMUX1.bit.GPIO12= 1; // GPIO12 as /TZ1
	GpioCtrlRegs.GPAMUX2.all = 0;		// GPIO31 ... GPIO16 = General Purpose I/O
	GpioCtrlRegs.GPBMUX1.all = 0;		// GPIO38 ... GPIO32 = General Purpose I/O
	GpioCtrlRegs.GPADIR.all = 0;
	GpioCtrlRegs.GPADIR.bit.GPIO18 = 1;	// GPIO18 to output
	GpioDataRegs.GPADAT.bit.GPIO18 = 1; // to 1 (passive) initially
	GpioCtrlRegs.GPBDIR.all = 0;		// GPIO38 ... GPIO32 as inputs
	GpioCtrlRegs.GPBDIR.bit.GPIO34 = 1;	// GPIO34 as output (LED LD2 at 28027stick)
	EDIS;
}  

void Setup_ePWM1A(void)
{
	EPwm1Regs.TBCTL.all = 0;			// default status
	EPwm1Regs.TBCTL.bit.CLKDIV =  0;	// CLKDIV = 1		
	EPwm1Regs.TBCTL.bit.HSPCLKDIV = 0;	// HSPCLKDIV = 1
	EPwm1Regs.TBCTL.bit.CTRMODE = 2;	// up - down mode

	EPwm1Regs.AQCTLA.all = 0x0060;		// set ePWM1A on CMPA up
										// clear ePWM1A on CMPA down
										
	EPwm1Regs.AQCTLB.all = 0x0600;		// set ePWM1B on CMPB up
										// clear ePWM1B on CMPB down

	EPwm1Regs.TBPRD = 30000;	// 1KHz - PWM signal
								//  TBPRD = fcpu / (2*fPWM * CLKDIV * HSPCLKDIV)
								//  TPPRD = 60 MHz / (2 * 1KHz * 1 * 1) = 30000
	EPwm1Regs.CMPA.half.CMPA = EPwm1Regs.TBPRD / 2;	// 50% duty cycle first
	EPwm1Regs.CMPB  = 	EPwm1Regs.TBPRD / 2;
	
	EALLOW;	
	EPwm1Regs.TZCTL.bit.TZA = 2;		// force ePWM1A to zero
	EPwm1Regs.TZCTL.bit.TZB = 2;		// force ePWM1B to zero
	//EPwm1Regs.TZSEL.bit.OSHT1 = 1;		// select TZ1 as source for one shot
	EPwm1Regs.TZSEL.bit.CBC1 = 1;		// now TZ1 as cycle by cycle over current
	EPwm1Regs.TZEINT.bit.CBC = 1;		// enable CBC interrupt
	EDIS;
} 

interrupt void cpu_timer0_isr(void)
{
	CpuTimer0.InterruptCount++;
	if(CpuTimer0.InterruptCount >= 10)
	{
		GpioDataRegs.GPATOGGLE.bit.GPIO18 = 1;
		CpuTimer0.InterruptCount = 0;
	}
	EALLOW;
	SysCtrlRegs.WDKEY = 0xAA;	// service WD #2
	EDIS;
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
}

interrupt void ePWM1_TZ_isr(void)
{
	EALLOW;
	EPwm1Regs.TZCLR.bit.CBC = 1;
	EPwm1Regs.TZCLR.bit.INT = 1;	// reset interrupt flags
	SysCtrlRegs.WDKEY = 0x55;		// service WD #1
	EDIS;
	GpioDataRegs.GPBTOGGLE.bit.GPIO34 = 1;	// LED LD2
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;

}

//===========================================================================
// End of SourceCode.
//===========================================================================
