// Support file for Lab7_11
#include "DSP2833x_Device.h"
extern Uint16 IR_Toggle;
extern Uint16 result[100];
extern Uint16 IR_address;
extern Uint16 IR_command;
extern Uint16 signal_IR_ready;

/*****************************************************************************/
/* 	Function to build the IR - Code (RC5) from message string result[100]	 */
/*  Example:																 */
/*  input: result[100]="P,S,S,L,S,S,S,S,S,S,S,S,S,S,S,S,S,S,L,S,S,L,S,S,P"	 */
/*						1, 1, 0,  0,  0,  0,  0,  0,  0,  0, 1, 1, 0, 0 	 */
/*  output:  ir_code = 0x300C												 */
/*  IR_address = 0															 */
/*  IR_Toggle  = 0															 */			 
/*  IR_command = 12															 */
/*****************************************************************************/
 
void Calculate_IR_code(void)
{
	// compute device address and command code
	Uint16 i,ir_code=0;
	Uint16 current_bit,prev_bit;
	Uint16 error=0;
	if (result[0] != 'P') error = 1;		// sequence must start with a 'P'
	else
	{
		current_bit = 1;
		ir_code = (ir_code<<1)+current_bit;
		prev_bit = current_bit;
		for(i=1;result[i]!='P';i++)
		{
			if((result[i] == 'S') && (result[i+1] == 'S'))
			{
				current_bit = prev_bit;
				ir_code = (ir_code <<1)+current_bit;
				prev_bit = current_bit;
				i=i+1;	
			}
			else
			{
				if (result[i] == 'L')
				{
					current_bit = (~prev_bit) & 0x0001;
					ir_code = (ir_code <<1)+current_bit;
					prev_bit = current_bit;
				}
			}
			
		}	

	}
	IR_Toggle = (ir_code & 0x800)>>11;
	IR_address = (ir_code & 0x7C0) >> 6;
	IR_command = (ir_code & 0x3F);

}

/*****************************************************************************/
/* Interrupt Service  Function for eCAP4									 */
/* triggered after 4 consecutive edges falling - rising - falling - rising	 */
/* Code calculates the time between edges and 								 */
/* stores the sequence in global variable result[100]						 */
/* code for pause, short, long is 'P', 'S' and 'L' 							 */
/* Example for command "TV" and "POWER":									 */
/*   P,S,S,L,S,S,S,S,S,S,S,S,S,S,S,S,S,S,L,S,S,L,S,S,P						 */
/*   1, 1, 0,  0,  0,  0,  0,  0,  0,  0, 1, 1, 0, 0 						 */
/*                                 ----------------- code C5..C0 = 12		 */
/*            ------------------  address = 0								 */
/*         --  T=0															 */
/*      --  -code C6 = 1      												 */
/*   -- Start = 1															 */
/*****************************************************************************/
interrupt void eCAP4_isr(void)
{
	Uint32 temp[4];
	Uint16 i=0,temp_idx;
	static Uint16 begin_of_frame = 0;		// switch
	static Uint16 end_of_frame = 0;
	static Uint16 result_idx = 0;

	// read four captures falling-rising-falling-rising
	temp[i++] = ECap4Regs.CAP1;
	temp[i++] = ECap4Regs.CAP2;
	temp[i++] = ECap4Regs.CAP3;
	temp[i]   = ECap4Regs.CAP4;

	if (begin_of_frame == 0) // not yet found
	{
		for(i=0;i<4;i++)
		{
			if (temp[i] > 750000)	// 5 ms as idle separator (RC-5 : 113ms)
			{
				begin_of_frame = 1;
				result_idx = 0;
				result[result_idx++] = 'P';
				temp_idx = i+1;
			}
		}
		while(temp_idx <4)			// compute remaining captures of fist ISR
		{
			if(temp[temp_idx++] < 187500)			// 1.25 ms
				result[result_idx++] = 'S';		// short width
			else 
				result[result_idx++] = 'L';		// large width
		}
	}
	
	else 		// begin_of_frame == 1 
	{ 
		if (end_of_frame == 0)		// not yet received
		{
			for(i=0;i<4;i++)
			{
				if (temp[i] < 187500)
				{
					result[result_idx++] = 'S';
				}
				else 
				{
					if (temp[i] > 750000) 
					{
						end_of_frame = 1;
						result[result_idx++] = 'P';
					}	
					else result[result_idx++] = 'L';
				}
			}

		}	
	}
	
	if (end_of_frame == 1)
	{
		signal_IR_ready = 1;
		end_of_frame = 0;
		begin_of_frame = 0;
		result_idx = 0;
	}	
	ECap4Regs.ECCLR.bit.CEVT4 = 1;				// Clear the CEVT4 flag	
	ECap4Regs.ECCLR.bit.INT = 1;				// Clear the ECAP4 main interrupt flag
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP4;	// Must acknowledge the PIE group 4
}
