//
//      Lab7_11: TMS320F28335
//      (c) Frank Bormann
//
//###########################################################################
//
// FILE:	Lab7_11.c
// 
// TITLE:	DSP28335ControlCARD; IR - remote receiver RC5(Manchester) code
//			and measurement with eCAP4
//			solution file for Lab7_11
//###########################################################################
//  Ver | dd mmm yyyy | Who  | Description of changes
// =====|=============|======|===============================================
//  3.0 | 13 May 2009 | F.B. | Lab7_11 for F28335; 
//  3.1 | 11 Nov 2009 | F.B  | Lab7_11 for F28335 and PE Revision 5
//###########################################################################
#include "DSP2833x_Device.h"

// external function prototypes
extern void InitSysCtrl(void);
extern void InitPieCtrl(void);
extern void InitPieVectTable(void);
extern void InitCpuTimers(void);
extern void ConfigCpuTimer(struct CPUTIMER_VARS *, float, float);
extern void Calculate_IR_code(void);
extern interrupt void eCAP4_isr(void);

// Prototype statements for functions found within this file.
void Gpio_select(void);
void Setup_eCAP4(void);
interrupt void cpu_timer0_isr(void);

// Global Variables
Uint16 result[100];
Uint16 signal_IR_ready=0;
Uint16 IR_address;			// device address code RC-5
Uint16 IR_command;			// device command code RC-5
Uint16 IR_Toggle;
//###########################################################################
//						main code									
//###########################################################################
void main(void)
{
	Uint16 i;
	Uint16 counter=0;	// binary counter for digital output

	InitSysCtrl();	// Basic Core Init from DSP2833x_SysCtrl.c

	EALLOW;
   	SysCtrlRegs.WDCR= 0x00AF;	// Re-enable the watchdog 
   	EDIS;			// 0x00AF  to NOT disable the Watchdog, Prescaler = 64

	DINT;				// Disable all interrupts
	
	Gpio_select();		// GPIO9, GPIO11, GPIO34 and GPIO49 as output
					    // to 4 LEDs at Peripheral Explorer Board

	Setup_eCAP4();		// init  eCAP4
	
	InitPieCtrl();		// basic setup of PIE table; from DSP2833x_PieCtrl.c
	
	InitPieVectTable();	// default ISR's in PIE

	EALLOW;
	PieVectTable.TINT0 = &cpu_timer0_isr;
	PieVectTable.ECAP4_INT= &eCAP4_isr;
	EDIS;

	InitCpuTimers();	// basic setup CPU Timer0, 1 and 2

	ConfigCpuTimer(&CpuTimer0,150,100000);

	for(i=0;i<100;i++)result[i] = 0;

	PieCtrlRegs.PIEIER1.bit.INTx7 = 1;	// Enable CPU Timer 0 INT
	PieCtrlRegs.PIEIER4.bit.INTx4 = 1;	// Enable ECAP4_INT in PIE group 4
	IER |= 0x0009;						// Enable INT4 and INT1

	EINT;
	ERTM;

	CpuTimer0Regs.TCR.bit.TSS = 0;	// start timer0
	
	while(1)
	{    
	  		while(CpuTimer0.InterruptCount == 0);
			CpuTimer0.InterruptCount = 0;
			
			EALLOW;
			SysCtrlRegs.WDKEY = 0x55;	// service WD #1
			EDIS;

	  		counter++;
			if(counter&1) GpioDataRegs.GPASET.bit.GPIO9 = 1;
				else GpioDataRegs.GPACLEAR.bit.GPIO9 = 1;		// life indicator
			if (signal_IR_ready==1)
			{
				Calculate_IR_code();
				// Toggle GPIO11 if ON/OFF IR remote command has been received
				if(IR_command == 12) GpioDataRegs.GPATOGGLE.bit.GPIO11 = 1;
				// Prepare next run
				for(i=0;i<100;i++)result[i] = 0;
				signal_IR_ready=0;
			}

	}
} 

void Gpio_select(void)
{
	EALLOW;
	GpioCtrlRegs.GPAMUX1.all = 0;		// GPIO15 ... GPIO0 = General Puropse I/O
	GpioCtrlRegs.GPAMUX1.bit.GPIO0 = 1;	// ePWM1A active
	
	GpioCtrlRegs.GPAMUX2.all = 0;		// GPIO31 ... GPIO16 = General Purpose I/O
	GpioCtrlRegs.GPAMUX2.bit.GPIO27= 1;	// eCAP4 active 
	GpioCtrlRegs.GPBMUX1.all = 0;		// GPIO47 ... GPIO32 = General Purpose I/O
	GpioCtrlRegs.GPBMUX2.all = 0;		// GPIO63 ... GPIO48 = General Purpose I/O
	GpioCtrlRegs.GPCMUX1.all = 0;		// GPIO79 ... GPIO64 = General Purpose I/O
	GpioCtrlRegs.GPCMUX2.all = 0;		// GPIO87 ... GPIO80 = General Purpose I/O
	 
	GpioCtrlRegs.GPADIR.all = 0;
	GpioCtrlRegs.GPADIR.bit.GPIO9 = 1;	// peripheral explorer: LED LD1 at GPIO9
	GpioCtrlRegs.GPADIR.bit.GPIO11 = 1;	// peripheral explorer: LED LD2 at GPIO11

	GpioCtrlRegs.GPBDIR.all = 0;		// GPIO63-32 as inputs
	GpioCtrlRegs.GPBDIR.bit.GPIO34 = 1;	// peripheral explorer: LED LD3 at GPIO34
	GpioCtrlRegs.GPBDIR.bit.GPIO49 = 1; // peripheral explorer: LED LD4 at GPIO49

	GpioCtrlRegs.GPCDIR.all = 0;		// GPIO87-64 as inputs
	EDIS;
}  

void Setup_eCAP4(void)
{
//---------------------------------------------------------------------
//--- Configure eCAP4 unit for capture                        
//---------------------------------------------------------------------
//  4 falling edges
	ECap4Regs.ECEINT.all = 0;			// Disable all capture interrupts
	ECap4Regs.ECCLR.all = 0xFFFF;		// clear all interrupt flags


	ECap4Regs.ECCTL1.all = 0;
	ECap4Regs.ECCTL1.bit.CAP1POL = 1;		// Capture on falling edge
	ECap4Regs.ECCTL1.bit.CAP2POL = 0;  		// Capture on rising edge
	ECap4Regs.ECCTL1.bit.CAP3POL = 1; 		// Capture on falling edge
	ECap4Regs.ECCTL1.bit.CAP4POL = 0; 		// Capture on rising edge

	ECap4Regs.ECCTL1.bit.CTRRST1 = 1;		// Delta Mode
	ECap4Regs.ECCTL1.bit.CTRRST2 = 1;		// Delta Mode
	ECap4Regs.ECCTL1.bit.CTRRST3 = 1;		// Delta Mode
	ECap4Regs.ECCTL1.bit.CTRRST4 = 1;		// Delta Mode

	ECap4Regs.ECCTL1.bit.CAPLDEN = 1;		// Enables loading of CAP registers at capture
	ECap4Regs.ECCTL1.bit.PRESCALE = 0;		// No prescaling
	ECap4Regs.ECCTL1.bit.FREE_SOFT = 2;		// Run free

	ECap4Regs.ECCTL2.all = 0;
	ECap4Regs.ECCTL2.bit.CAP_APWM = 0;		// Capture mode
	ECap4Regs.ECCTL2.bit.SYNCO_SEL = 2;		// Disable sync signal
	ECap4Regs.ECCTL2.bit.SYNCI_EN = 0;		// Disable sync in option
	ECap4Regs.ECCTL2.bit.TSCTRSTOP = 1;		// Free Running
	ECap4Regs.ECCTL2.bit.CONT_ONESHT = 0;	// Continuous mode
	ECap4Regs.ECCTL2.bit.STOP_WRAP = 3;		// Wrap after Capture Event 4
	
	ECap4Regs.ECEINT.all = 0;
	ECap4Regs.ECEINT.bit.CEVT4 = 1;			// Enable event 4 interrupt
} // end InitECap()

interrupt void cpu_timer0_isr(void)
{
	CpuTimer0.InterruptCount++;
	EALLOW;
	SysCtrlRegs.WDKEY = 0xAA;	// service WD #2
	EDIS;
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
}


//===========================================================================
// End of SourceCode.
//===========================================================================
