//
//      Lab9_3: TMS320F28335
//      (c) Frank Bormann
//
//###########################################################################
//
// FILE:	Lab9_3.c
// 
// TITLE:	DSP28 SCI - Communication to PC - Terminal
//			DSC sends the string "Burst-Transmit\n\r!" every 2 seconds
//			CPU Timer0 ISR every 50 ms
//			SCI-Setup: 9600 Baud, 8 Bit , ODD Parity , 1 Stopbit	
//			SCI - TX - Interrupt used in this Lab 
//			SCI - TX - FIFO is used in this Lab
//			Watchdog active , serviced in ISR and main-loop 
//###########################################################################
//  Ver | dd mmm yyyy | Who  | Description of changes
// =====|=============|======|===============================================
//  3.0 | 08 Jul 2009 | F.B. | adapted for ControlCard28335 @ 20MHz
//  3.1 | 15 Nov 2009 | F.B  | Lab9_3 for F28335 @30MHz and PE revision 5
//###########################################################################
#include "DSP2833x_Device.h"

// External Function prototypes
extern void InitSysCtrl(void);
extern void InitPieCtrl(void);
extern void InitPieVectTable(void);
extern void InitCpuTimers(void);
extern void ConfigCpuTimer(struct CPUTIMER_VARS *, float, float);

// Prototype statements for functions found within this file.
void Gpio_select(void);
void SCIA_init(void);
interrupt void cpu_timer0_isr(void); // Prototype for Timer 0 Interrupt Service Routine
interrupt void SCIA_TX_isr(void);	 // SCI-A Transmit Interrupt Service

// Global Variables
char message[]={"Burst-Transmit\n\r"};
int index =0;			// index variable into message

//###########################################################################
//						main code									
//###########################################################################
void main(void)
{
	InitSysCtrl();	// Basic Core Initialization
					// SYSCLK=150MHz, HISPCLK=75MHz, LSPCLK=37.5MHz
	EALLOW;
   	SysCtrlRegs.WDCR= 0x00AF;		  // Re-enable the watchdog 
   	EDIS;			// 0x00E8  to disable the Watchdog , Prescaler = 1
   					// 0x00AF  to NOT disable the Watchdog, Prescaler = 64
	
	Gpio_select();	// GPIO9, GPIO11, GPIO34 and GPIO49 as output
					// to 4 LEDs at Peripheral Explorer		
	
	InitPieCtrl();	// default status of PIE; in DSP2833x_PieCtrl.c
	
	InitPieVectTable(); // init PIE vector table; in DSP2833x_PieVect.c
	
	// re-map PIE - entry for Timer 0 Interrupt and SCI-A-TX
	EALLOW;  
   	PieVectTable.TINT0 = &cpu_timer0_isr;
	PieVectTable.SCITXINTA = &SCIA_TX_isr;
   	EDIS;    
   		
	InitCpuTimers();	// Function in: DSP2833x_CpuTimers.c	
	
	// Configure CPU-Timer 0 to interrupt every 50 ms:
	// 150MHz CPU Freq, 50000 seconds interrupt period
    ConfigCpuTimer(&CpuTimer0, 150, 50000);	// DSP2833x_CpuTimers.c
    
   	SCIA_init();  // Initalize SCI 
   
    PieCtrlRegs.PIEIER1.bit.INTx7 = 1;	// Cpu Timer 0 isr
	PieCtrlRegs.PIEIER9.bit.INTx2 = 1;  // SCI-A-TX-isr


	// Enable CPU INT1 (CPU-Timer 0) and INT9 (SCIA-TX):
    IER = 0x101;
    
	// Enable global Interrupts and higher priority real-time debug events:
   	EINT;   // Enable Global interrupt INTM
   	ERTM;   // Enable Global realtime interrupt DBGM
   	
   	CpuTimer0Regs.TCR.bit.TSS = 0;		// Start T0
   	
	while(1)
	{    
	  	while(CpuTimer0.InterruptCount < 40)  	// 40 * 50ms = 2 sec
	 	{
			EALLOW;
			SysCtrlRegs.WDKEY = 0xAA;			// Service watchdog #2
			EDIS;
		}
		CpuTimer0.InterruptCount = 0;
		SciaRegs.SCIFFTX.bit.TXFFINTCLR = 1;	// re-arm Tx - FIFO
	}
} 	

void Gpio_select(void)
{
	EALLOW;
	GpioCtrlRegs.GPAMUX1.all = 0;			// GPIO15 ... GPIO0 = General Puropse I/O
	GpioCtrlRegs.GPAMUX2.all = 0;			// GPIO31 ... GPIO16 = General Purpose I/O
	
	GpioCtrlRegs.GPAMUX2.bit.GPIO28 = 1;	// SCIRXDA
	GpioCtrlRegs.GPAMUX2.bit.GPIO29 = 1;	// SCITXDA	
	
	GpioCtrlRegs.GPBMUX1.all = 0;			// GPIO47 ... GPIO32 = General Purpose I/O
	GpioCtrlRegs.GPBMUX2.all = 0;			// GPIO63 ... GPIO48 = General Purpose I/O
	GpioCtrlRegs.GPCMUX1.all = 0;			// GPIO79 ... GPIO64 = General Purpose I/O
	GpioCtrlRegs.GPCMUX2.all = 0;			// GPIO87 ... GPIO80 = General Purpose I/O
	 
	GpioCtrlRegs.GPADIR.all = 0;
	GpioCtrlRegs.GPADIR.bit.GPIO9 = 1;		// peripheral explorer: LED LD1 at GPIO9
	GpioCtrlRegs.GPADIR.bit.GPIO11 = 1;		// peripheral explorer: LED LD2 at GPIO11

	GpioCtrlRegs.GPBDIR.all = 0;			// GPIO63-32 as inputs
	GpioCtrlRegs.GPBDIR.bit.GPIO34 = 1;	// peripheral explorer: LED LD3 at GPIO34
	GpioCtrlRegs.GPBDIR.bit.GPIO49 = 1; // peripheral explorer: LED LD4 at GPIO49

	GpioCtrlRegs.GPCDIR.all = 0;			// GPIO87-64 as inputs
	EDIS;
} 

void SCIA_init()
{    
   	SciaRegs.SCICCR.all =0x0027;   	// 1 stop bit,  No loopback 
                                   	// ODD parity,8 char bits,
                                   	// async mode, idle-line protocol
	SciaRegs.SCICTL1.all =0x0003;  	// enable TX, RX, internal SCICLK, 
                                   	// Disable RX ERR, SLEEP, TXWAKE
	
	// SYSCLOCKOUT = 150MHz; LSPCLK = 1/4 = 37.5 MHz
	// BRR = (LSPCLK / (9600 x 8)) -1
	// BRR = 487  gives 9605 Baud
	SciaRegs.SCIHBAUD    = 487 >> 8;		// Highbyte
	SciaRegs.SCILBAUD    = 487 & 0x00FF;	// Lowbyte

	SciaRegs.SCICTL2.bit.TXINTENA = 1; // enable SCI-A Tx-ISR

	SciaRegs.SCIFFTX.all = 0xC060;	// bit 15 = 1 : relinquish from Reset
									// bit 14 = 1 : Enable FIFO
									// bit 6 = 1 :  CLR TXFFINT-Flag
									// bit 5 = 1 :  enable TX FIFO match
									// bit 4-0 :  TX-ISR, if TX FIFO is 0(empty) 
	SciaRegs.SCIFFCT.all = 0x0000;	// Set FIFO transfer delay to 0
	SciaRegs.SCIFFTX.bit.TXFIFOXRESET = 1;  // re-enable transmit fifo operation

	SciaRegs.SCICTL1.all = 0x0023;	// Relinquish SCI from Reset 
}  

interrupt void cpu_timer0_isr(void)
{
    CpuTimer0.InterruptCount++;		// increment time counter
   	GpioDataRegs.GPBTOGGLE.bit.GPIO34 = 1; // toggle LED at GPIO34
   	// Service the watchdog every Timer 0 interrupt
   	EALLOW;
	SysCtrlRegs.WDKEY = 0x55;		// Service watchdog #1
	EDIS;
   	// Acknowledge this interrupt to receive more interrupts from group 1
   	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
}

interrupt void SCIA_TX_isr(void)	 // SCI-A Transmit Interrupt Service
{
	unsigned int i;
	// copy 16 character into SCI-A TX buffer
	for(i=0;i<16;i++) SciaRegs.SCITXBUF= message[i];
	// Acknowledge this interrupt to receive more interrupts from group 9
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;  
}

//===========================================================================
// End of SourceCode.
//===========================================================================
