//
//      Lab9_4: TMS320F28335
//      (c) Frank Bormann
//
//###########################################################################
//
// FILE:	Lab9_4.c
// 
// TITLE:	DSP28 SCI - Communication to PC - Terminal
//			SCI-Setup: 9600 Baud, 8 Bit , ODD Parity , 1 Stopbit	
//			SCI - TX and RX - Interrupt are used in this Lab 
//			SCI - TX and RX - FIFO are used in this Lab
//			DSP waits for "Texas" and answers with "Instruments"
//			Watchdog active , serviced solely in main-loop 
//###########################################################################
//  Ver | dd mmm yyyy | Who  | Description of changes
// =====|=============|======|===============================================
//  3.0 | 08 Jul 2009 | F.B. | adapted for ControlCard28335 @ 20MHz
//  3.1 | 15 Nov 2009 | F.B  | Lab9_4 for F28335 @30MHz and PE revision 5
//###########################################################################
#include "DSP2833x_Device.h"
#include <string.h>
  
// External Function prototypes
extern void InitSysCtrl(void);
extern void InitPieCtrl(void);
extern void InitPieVectTable(void);

// Prototype statements for functions found within this file.
void Gpio_select(void);
void SCIA_init(void);
interrupt void SCIA_TX_isr(void);	 // SCI-A Transmit Interrupt Service
interrupt void SCIA_RX_isr(void);	 // SCI-A Receive  Interrupt Service

// Global Variables
char message[]={" Instruments! \n\r"};

//###########################################################################
//						main code									
//###########################################################################
void main(void)
{
	InitSysCtrl();	// Basic Core Initialization
					// SYSCLK=150MHz, HISPCLK=75MHz, LSPCLK=37.5MHz
	EALLOW;
   	SysCtrlRegs.WDCR= 0x00AF;		  // Re-enable the watchdog 
   	EDIS;			// 0x00E8  to disable the Watchdog , Prescaler = 1
   					// 0x00AF  to NOT disable the Watchdog, Prescaler = 64
	
	Gpio_select();	// GPIO9, GPIO11, GPIO34 and GPIO49 as output
					// to 4 LEDs at Peripheral Explorer			
	
	InitPieCtrl();		// default status of PIE; in DSP2833x_PieCtrl.c
	
	InitPieVectTable(); // init PIE vector table; in DSP2833x_PieVect.c
	
	// re-map PIE - entry for SCI-A-TX and SCI-A-RX
	EALLOW;  
   	PieVectTable.SCITXINTA = &SCIA_TX_isr;
	PieVectTable.SCIRXINTA = &SCIA_RX_isr;
   	EDIS;    
   		
   	SCIA_init();  // Initalize SCI 
   
    // Enable SCI-A TX Interrupt Group9 interupt 2
	PieCtrlRegs.PIEIER9.bit.INTx2 = 1;
	// Enable SCI-A RX Interrupt Group9 interupt 1
	PieCtrlRegs.PIEIER9.bit.INTx1 = 1;


	// Enable INT9 for SCIA-TX and SCIA-RX:
    IER = 0x100;
    
	// Enable global Interrupts and higher priority real-time debug events:
   	EINT;   // Enable Global interrupt INTM
   	ERTM;   // Enable Global realtime interrupt DBGM
   	
	while(1)
	{    
	  	EALLOW;
		SysCtrlRegs.WDKEY = 0x55;			// Service watchdog #1
		SysCtrlRegs.WDKEY = 0xAA;			// Service watchdog #2
		EDIS;
	}
} 	

void Gpio_select(void)
{
	EALLOW;
	GpioCtrlRegs.GPAMUX1.all = 0;			// GPIO15 ... GPIO0 = General Puropse I/O
	GpioCtrlRegs.GPAMUX2.all = 0;			// GPIO31 ... GPIO16 = General Purpose I/O
	
	GpioCtrlRegs.GPAMUX2.bit.GPIO28 = 1;	// SCIRXDA
	GpioCtrlRegs.GPAMUX2.bit.GPIO29 = 1;	// SCITXDA	
	
	GpioCtrlRegs.GPBMUX1.all = 0;			// GPIO47 ... GPIO32 = General Purpose I/O
	GpioCtrlRegs.GPBMUX2.all = 0;			// GPIO63 ... GPIO48 = General Purpose I/O
	GpioCtrlRegs.GPCMUX1.all = 0;			// GPIO79 ... GPIO64 = General Purpose I/O
	GpioCtrlRegs.GPCMUX2.all = 0;			// GPIO87 ... GPIO80 = General Purpose I/O
	 
	GpioCtrlRegs.GPADIR.all = 0;
	GpioCtrlRegs.GPADIR.bit.GPIO9 = 1;		// peripheral explorer: LED LD1 at GPIO9
	GpioCtrlRegs.GPADIR.bit.GPIO11 = 1;		// peripheral explorer: LED LD2 at GPIO11

	GpioCtrlRegs.GPBDIR.all = 0;			// GPIO63-32 as inputs
	GpioCtrlRegs.GPBDIR.bit.GPIO34 = 1;	// peripheral explorer: LED LD3 at GPIO34
	GpioCtrlRegs.GPBDIR.bit.GPIO49 = 1; // peripheral explorer: LED LD4 at GPIO49

	GpioCtrlRegs.GPCDIR.all = 0;			// GPIO87-64 as inputs
	EDIS;
} 

void SCIA_init()
{    
   	SciaRegs.SCICCR.all =0x0027;   	// 1 stop bit,  No loopback 
                                   	// ODD parity,8 char bits,
                                   	// async mode, idle-line protocol
	SciaRegs.SCICTL1.all =0x0003;  	// enable TX, RX, internal SCICLK, 
                                   	// Disable RX ERR, SLEEP, TXWAKE
	
	// SYSCLOCKOUT = 150MHz; LSPCLK = 1/4 = 37.5 MHz
	// BRR = (LSPCLK / (9600 x 8)) -1
	// BRR = 487  gives 9605 Baud
	SciaRegs.SCIHBAUD    = 487 >> 8;		// Highbyte
	SciaRegs.SCILBAUD    = 487 & 0x00FF;	// Lowbyte

	SciaRegs.SCICTL2.bit.TXINTENA = 1; 		// enable SCI-A Tx-ISR
	SciaRegs.SCICTL2.bit.RXBKINTENA = 1; 	// enable SCI_A Rx-ISR

	SciaRegs.SCIFFTX.all = 0xC060;	// bit 15 = 1 : relinquish from Reset
									// bit 14 = 1 : Enable FIFO
									// bit 6 = 1 :  CLR TXFFINT-Flag
									// bit 5 = 1 :  enable TX FIFO match
									// bit 4-0 :  TX-ISR, if TX FIFO is 0(empty) 
	SciaRegs.SCIFFCT.all = 0x0000;	// Set FIFO transfer delay to 0
	
	SciaRegs.SCIFFRX.all = 0xE065;	// Rx interrupt level = 5

	SciaRegs.SCICTL1.all = 0x0023;	// Relinquish SCI from Reset 
}  

// SCI-A Transmit Interrupt Service
interrupt void SCIA_TX_isr(void)	 
{
	unsigned int i;
	// copy 16 character into SCI-A TX buffer
	for(i=0;i<16;i++) SciaRegs.SCITXBUF= message[i];
	// Acknowledge this interrupt to receive more interrupts from group 9
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;  
}

// SCI-A Receive Interrupt Service
interrupt void SCIA_RX_isr(void)
{
	int i;
	char buffer[16];
	for (i=0;i<16;i++) buffer[i]= SciaRegs.SCIRXBUF.bit.RXDT;
	
	if (strncmp(buffer, "Texas", 5) == 0)
	{
		SciaRegs.SCIFFTX.bit.TXFIFOXRESET =1;  // enable TXFIFO
		SciaRegs.SCIFFTX.bit.TXFFINTCLR = 1 ;  // force TX-ISR		
	}
	 	
	SciaRegs.SCIFFRX.bit.RXFIFORESET = 0;	// reset RX-FIFO pointer  
	SciaRegs.SCIFFRX.bit.RXFIFORESET = 1;	// enable RX-operation
	SciaRegs.SCIFFRX.bit.RXFFINTCLR = 1;    // clear RX-FIFO INT Flag
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;  
}

//===========================================================================
// End of SourceCode.
//===========================================================================
