//
//      Lab16: TMS320F28335
//      (C) Frank Bormann
//
//###########################################################################
//
// FILE:	Lab16.c
//
// TITLE:	FLASH - API functional test
//			store analogue value of ADCINA0 in FLASHB ("FLASH_Voltage_A0")
//		    when button 'START' is pushed
//			display "constant_Voltage_A0" from as light beam at 4 LEDs  
//			CPU Timer0 ISR every 50 ms
//			Watchdog active , serviced in ISR and main-loop 
//			ISR's are copied from Flash into RAML0 before called
//		    Therefore ISR's can stay enabled during the flash update
//			of variable "constant_Voltage_A0" 
//###########################################################################
//
//  Ver | dd mmm yyyy | Who  | Description of changes
// =====|=============|======|===============================================
//  1.0 | 11 Jul 2007 | F.B. | Prototype   
//	1.1 | 20 Jul 2007 |      | adapted for Systec Board
//  2.1 | 20 Jun 2008 |      | CCS3.3.81; cgtools 5.2.2; Peripheral Explorer
//	2.2 | 16 Sep 2008 |		 | 28335 Header files version 1.31
//	3.0 | 20 Sep 2009 |      | F28335 Peripheral Explorer version
//  3.1 | 22 Nov 2009 | F.B  | Lab16 for F28335 @30MHz and PE revision 5
//##########################################################################
#include "DSP2833x_Device.h"

#define START GpioDataRegs.GPADAT.bit.GPIO17		// Button PB1
#define STOP  GpioDataRegs.GPBDAT.bit.GPIO48		// Button PB2

// External Function prototypes
extern void InitSysCtrl(void);
extern void InitPieCtrl(void);
extern void InitPieVectTable(void);
extern void InitFlash(void);
extern void Update_FLASHB(int);
extern void InitAdc(void);	
extern void display_ADC(unsigned int);

// external symbols for section ramfuncs
extern unsigned int  RamfuncsLoadStart;
extern unsigned int  RamfuncsLoadEnd;
extern unsigned int  RamfuncsRunStart;

// Prototype statements for functions found within this file.
void Gpio_select(void);
interrupt void cpu_timer0_isr(void); // Prototype for Timer 0 Interrupt Service Routine
interrupt void adc_isr(void);		 // ADC Interrupt service

// global variables
unsigned int Voltage_A0;	// ADC voltage from ADCINA0
extern unsigned int FLASH_Voltage_A0; 
//###########################################################################
//						main code									
//###########################################################################
void main(void)
{
	InitSysCtrl();					// Basic Core Initialization

	 // Copy time critical code and Flash setup code to RAM
   	memcpy(&RamfuncsRunStart, &RamfuncsLoadStart, &RamfuncsLoadEnd - &RamfuncsLoadStart);
	InitFlash();					// Speed up FLASH memory 

	EALLOW;
   	SysCtrlRegs.WDCR= 0x00AF;		// Re-enable watchdog 
   	EDIS;							// 0x00E8  to disable the Watchdog , Prescaler = 1
   									// 0x00AF  enable the Watchdog, Prescaler = 64
	
	Gpio_select();	

	InitPieCtrl();		// extern function Call to init PIE-unit (DSP2833x_PieCtrl.c)
	
	InitPieVectTable(); // extern function call to init PIE vector table (DSP2833x_PieVect.c )
	
	// re-map PIE - entry for Timer 0 Interrupt & ADC
	EALLOW;  
   	PieVectTable.TINT0 = &cpu_timer0_isr;
   	PieVectTable.ADCINT = &adc_isr;
   	EDIS;   
	
	InitCpuTimers();	// Function in: DSP2833x_CpuTimers.c	
	
	// Configure CPU-Timer 0 to interrupt every 50 ms:
	// 150MHz CPU Freq, 50000 seconds interrupt period
    ConfigCpuTimer(&CpuTimer0, 150, 50000);	// DSP2833x_CpuTimers.c

		// Power on to ADC
   	InitAdc();
	// Configure ADC 
	AdcRegs.ADCTRL1.all = 0;
	AdcRegs.ADCTRL1.bit.ACQ_PS = 7; 	// Aquisition window = 8x 
	AdcRegs.ADCTRL1.bit.CPS = 0;		// CPS = div by 1
	AdcRegs.ADCTRL1.bit.CONT_RUN = 0; 	// single run
	AdcRegs.ADCTRL1.bit.SEQ_CASC = 1; 	// cascaded mode 

	AdcRegs.ADCTRL2.all = 0;
	AdcRegs.ADCTRL2.bit.INT_ENA_SEQ1 = 1;	// enable Interrupt

	AdcRegs.ADCTRL3.bit.ADCCLKPS = 4;		// HSPCLK / (2 * CLKPS)

    AdcRegs.ADCMAXCONV.all = 0;       		// 1 conversion only
	
	AdcRegs.ADCCHSELSEQ1.bit.CONV00 = 0; // ADCINA0 

   // Enable PIE: Group 1 interrupts
   	PieCtrlRegs.PIEIER1.bit.INTx7 = 1; // TINT0
	PieCtrlRegs.PIEIER1.bit.INTx6 = 1; // ADC
	
	// Enable CPU INT1 which is connected to CPU-Timer 0:
    IER = 1;
    
	// Enable global Interrupts and higher priority real-time debug events:
   	EINT;   // Enable Global interrupt INTM
   	ERTM;   // Enable Global realtime interrupt DBGM
   	
   	CpuTimer0Regs.TCR.bit.TSS = 0;		// Start T0
   	
	GpioDataRegs.GPADAT.all = 0;		// All LED's off

	while(1)
	{    
  	    display_ADC(0);
		while(CpuTimer0.InterruptCount < 2); // wait for T0 2 * 50 ms = 100ms
  		display_ADC(FLASH_Voltage_A0);
  		while(CpuTimer0.InterruptCount < 4);
  		CpuTimer0.InterruptCount = 0;
	   	EALLOW;
    	SysCtrlRegs.WDKEY = 0xAA;		// and service watchdog #2		
	    EDIS;
	
		if (START == 0) // START Button is pressed down (zero)
		{
			// update FLASH section myFlashConstants in FLASHB 
			Update_FLASHB(Voltage_A0);
			
			EALLOW;
			SysCtrlRegs.WDCR = 0;			// cause a warm RESET		
			while(1);						// should never be reached
		}
	}
} 	

void Gpio_select(void)
{
	EALLOW;
	GpioCtrlRegs.GPAMUX1.all = 0;			// GPIO15 ... GPIO0 = General Puropse I/O
	GpioCtrlRegs.GPAMUX2.all = 0;			// GPIO31 ... GPIO16 = General Purpose I/O
	GpioCtrlRegs.GPBMUX1.all = 0;			// GPIO47 ... GPIO32 = General Purpose I/O
	GpioCtrlRegs.GPBMUX2.all = 0;			// GPIO63 ... GPIO48 = General Purpose I/O
	GpioCtrlRegs.GPCMUX1.all = 0;			// GPIO79 ... GPIO64 = General Purpose I/O
	GpioCtrlRegs.GPCMUX2.all = 0;			// GPIO87 ... GPIO80 = General Purpose I/O
	 
	GpioCtrlRegs.GPADIR.all = 0;
	GpioCtrlRegs.GPADIR.bit.GPIO9 = 1;		// peripheral explorer: LED LD1 at GPIO9
	GpioCtrlRegs.GPADIR.bit.GPIO11 = 1;		// peripheral explorer: LED LD2 at GPIO11

	GpioCtrlRegs.GPBDIR.all = 0;			// GPIO63-32 as inputs
	GpioCtrlRegs.GPBDIR.bit.GPIO34 = 1;	// peripheral explorer: LED LD3 at GPIO34
	GpioCtrlRegs.GPBDIR.bit.GPIO49 = 1; // peripheral explorer: LED LD4 at GPIO49

	GpioCtrlRegs.GPCDIR.all = 0;			// GPIO87-64 as inputs
	EDIS;
}   


#pragma CODE_SECTION(cpu_timer0_isr, "ramfuncs");
interrupt void cpu_timer0_isr(void)
{
    CpuTimer0.InterruptCount++;
   	// Serve the watchdog every Timer 0 interrupt
   	EALLOW;
	SysCtrlRegs.WDKEY = 0x55;		// Service watchdog #1
	EDIS;
	
	AdcRegs.ADCTRL2.bit.SOC_SEQ1 = 1;	// start ADC by SW

   	// Acknowledge this interrupt to receive more interrupts from group 1
   	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
}

#pragma CODE_SECTION(adc_isr, "ramfuncs");
interrupt void  adc_isr(void)
{

  Voltage_A0 = AdcRegs.ADCRESULT0>>4;
 
   // Reinitialize for next ADC sequence
  AdcRegs.ADCTRL2.bit.RST_SEQ1 = 1;         // Reset SEQ1
  AdcRegs.ADCST.bit.INT_SEQ1_CLR = 1;		// Clear INT SEQ1 bit
  PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;   // Acknowledge interrupt to PIE
  
}
//===========================================================================
// End of SourceCode.
//===========================================================================
