//
//      Lab14_FLASH: TMS320F28335
//      (C) Frank Bormann
//
//###########################################################################
//
// FILE:	Lab14_FLASH_API.c
//
// TITLE:	FLASH - API test
//			file covers the Flash - API calls used in Lab14_FLASH
//			Update_FLASHB(int);		// writes a single 16 bit word
//			Error();				// stops execution in case od FLASH - Error
//###########################################################################
//
//  Ver | dd mmm yyyy | Who  | Description of changes
// =====|=============|======|===============================================
//  1.0 | 27 Jul 2008 | F.B. | Prototype   
//	2.2 | 16 Sep 2008 | F.B. | API Version 2.10
//##########################################################################
#include "DSP2833x_Device.h"
#include "FLASH2833x_API_Library.h"
#include <stdio.h>  				// defines NULL

#define VALID_API_VERSION 0x210		// Version 2.1 for 28335 

extern Uint32 Flash_CPUScaleFactor;
extern Uint16 FLASH_Voltage_A0;

void Error(void);


void Update_FLASHB(Uint16 new_value)
{
	Uint16 * pSourceAddr;
    Uint16 * pDestAddr;
	Uint16 i;
	FLASH_ST Flash_Status;

	if (SysCtrlRegs.PLLSTS.bit.MCLKSTS == 0)
	{
	// continue only if not in LIMP-Mode
		// copy FLASH - API from FLASHD into RAML0
		pSourceAddr = &Flash28_API_LoadStart;
		pDestAddr = &Flash28_API_RunStart;
		for(i = 0; i < (&Flash28_API_LoadEnd-&Flash28_API_LoadStart); i++)
		{
	    	*pDestAddr++ = *pSourceAddr++;
		}
		
		Flash_CPUScaleFactor = SCALE_FACTOR;
		Flash_CallbackPtr = NULL;
		
		if (Flash_APIVersionHex() == VALID_API_VERSION)
		{
		// continue only if valid API - Library
			//	DINT;		// ISR's must be disabled, when the ISR is part of FLASH
							// if ISR is allocated in RAM, they can be active ( see lab03)
			// Erase Sector B
			i = Flash_Erase(SECTORB,&Flash_Status);
			if (i != STATUS_SUCCESS)Error();
			// Program a single 16 bit word into Variable "constant_Voltage_A0"
			i = Flash_Program(&FLASH_Voltage_A0,&new_value,1,&Flash_Status);		
			if (i != STATUS_SUCCESS)Error();
			//	EINT;
		}
	} 
}


void Error(void)
{
	DINT;
	asm(" ESTOP0");	   	  			// Code Execution stops here!!
	while(1);
}
