# -*- coding: utf-8 -*-
"""
Created on Wed Dec 10 15:50:58 2025

@author: HREELS
"""

import numpy as np
import matplotlib.pyplot as plt
from scipy.optimize import curve_fit
#from scipy.stats import norm

def gaussian(x, a, x0, sigma):
    return a*np.exp(-(x-x0)**2 / (2*sigma**2))

Ag111_clean_2 = np.loadtxt("Ag111_clean_2", skiprows=1)
Ag111_clean_4 = np.loadtxt("Ag111_clean_4", skiprows=1) # sample clean
Ag111_C60_1 = np.loadtxt("Ag111_C60_1", skiprows=1) # C60
Ag111_C60_2 = np.loadtxt("Ag111_C60_2", skiprows=1) # C60 long range
Ag111_C60_dd_1 = np.loadtxt("Ag111_C60_dd_1", skiprows=1) # C60 double deposition
Ag111_C60_dd_2 = np.loadtxt("Ag111_C60_dd_2", skiprows=1) # C60 double deposition long range

data = Ag111_clean_4
normalizing_h_clean2C60 = 2.8
x_data = data[:,0]
y_data = normalizing_h_clean2C60*data[:,1]

data_C60 = Ag111_C60_2
x_data_C60 = data_C60[:,0]
y_data_C60 = data_C60[:,1]

data_C60_dd = Ag111_C60_dd_2
normalizing_h_C60dd2C60 = 1.58
x_data_C60_dd = data_C60_dd[:,0]
y_data_C60_dd = normalizing_h_C60dd2C60*data_C60_dd[:,1]

p0_guess=np.array([1200, -5.41, 0.03])
fit_param, fit_err = curve_fit(gaussian, x_data, y_data, p0=p0_guess)
x = np.linspace(-5.7,-5,1000)
y_fit= gaussian(x,fit_param[0],fit_param[1],fit_param[2])

''' figure plotting '''

plt.figure()
#plt.plot(x_data,y_data, "b", label="Ag111_clean")
#plt.plot(x, y_fit, "r", label="fit")
plt.plot(x_data_C60,y_data_C60, "r", label="c60")
plt.plot(x_data_C60_dd,y_data_C60_dd, "g", label="c60_dd")
plt.xlabel("energy (V)")
plt.ylabel("counts per second (s$^{-1}$)")
plt.legend() 

FWHM=2.355*fit_param[2]


