clear
Tp=input('period: '); 
T1=input('pulse duration: ');
signal_type=input('type (1 rect, 2 triangle, 3 cos, 4 cos^2, 5 manchester, 6 raised cosine): '); 
if signal_type==6
    alpha=input('alpha: ');
end
dt=.01;
samples=1000;
info=2*(rand(1,samples+1)>.5)-1;
t=-samples/2*Tp:dt:samples/2*Tp;
x=zeros(1,length(t));
switch signal_type
    case 1
        for h=-samples/2:samples/2; t1=-samples/2*Tp+Tp*h:dt:samples/2*Tp+Tp*h;x=x+info(h+samples/2+1)*rect(t1,T1); end
    case 2        
        for h=-samples/2:samples/2; t1=-samples/2*Tp+Tp*h:dt:samples/2*Tp+Tp*h;x=x+info(h+samples/2+1)*triangle1(t1,T1); end
    case 3
        for h=-samples/2:samples/2; t1=-samples/2*Tp+Tp*h:dt:samples/2*Tp+Tp*h;x=x+info(h+samples/2+1)*rect(t1,T1).*cos(pi*t1/T1); end
    case 4
        for h=-samples/2:samples/2; t1=-samples/2*Tp+Tp*h:dt:samples/2*Tp+Tp*h;x=x+info(h+samples/2+1)*rect(t1,T1).*(cos(pi*t1/T1)).^2; end
    case 5
        for h=-samples/2:samples/2; t1=-samples/2*Tp+Tp*h:dt:samples/2*Tp+Tp*h;x=x+info(h+samples/2+1)*manchester(t1,T1); end
    case 6
        for h=-samples/2:samples/2; t1=-samples/2*Tp+Tp*h:dt:samples/2*Tp+Tp*h;x=x+info(h+samples/2+1)*raised_cosine(t1,T1,alpha); end
end
hold off
plot(t,x)
set(gca,'XLim',[-5,5])
set(gca,'YLim',[-2,2])
grid on
input('premere un tasto')
xf=fft(x);
xs=fftshift(xf);
df=1/dt/length(t);
f=-1/(2*dt)+df/2:df:1/(2*dt)-df/2;
plot(f,10*log10(abs(xs)/max(abs(xs))),'r')
set(gca,'XLim',[-3,3])
set(gca,'Ylim',[-30 0]);
switch(signal_type)
    case 1
        xt=T1*sinc(f*T1);
    case 2
        xt=T1/2*(sinc(f*T1/2)).^2;
    case 3
        xt=2*T1/(Tp*pi)*(cos(pi*f*T1))./(1-(2*f*T1).^2);
        xt(abs(f)==1/(2*T1))=T1/2;
    case 4
        xt=sin(pi*f*T1)./(1-(f*T1).^2)./(2*pi*f);
        xt(f==0)=T1/2;
        xt(abs(T1*f)==1)=T1/4;
    case 5
        xt=2*j*sinc(f*T1/2).*sin(pi*f*T1/2);
    case 6
        xt=zeros(1,length(f));
        xt(abs(f)<=(1-alpha)/(2*T1))=T1;
        xt(abs(f)>(1-alpha)/(2*T1)&abs(f)<=(1+alpha)/(2*T1))=T1/2*(1+cos(pi*T1/alpha*(abs(f(abs(f)>(1-alpha)/(2*T1)&abs(f)<=(1+alpha)/(2*T1)))-(1-alpha)/(2*T1))));
end
hold on
input('premere un tasto')
plot(f,10*log10(abs(xt)/max(abs(xt))),'k')
input('premere un tasto')
