clear
Tp=input('period: '); 
T1=input('pulse duration: ');
signal_type=input('type (1 rect, 2 triangle, 3 cos, 4 cos^2, 5 manchester, 6 raised cosine): '); 
if signal_type==6
    alpha=input('alpha: ');
end
dt=.01;
samples=50;
t=-samples/2*Tp:dt:samples/2*Tp;
x=zeros(1,length(t));
switch signal_type
    case 1
        for h=-samples/2:samples/2; t1=-samples/2*Tp+Tp*h:dt:samples/2*Tp+Tp*h;x=x+rect(t1,T1); end
    case 2        
        for h=-samples/2:samples/2; t1=-samples/2*Tp+Tp*h:dt:samples/2*Tp+Tp*h;x=x+triangle1(t1,T1); end
    case 3
        for h=-samples/2:samples/2; t1=-samples/2*Tp+Tp*h:dt:samples/2*Tp+Tp*h;x=x+rect(t1,T1).*cos(pi*t1/T1); end
    case 4
        for h=-samples/2:samples/2; t1=-samples/2*Tp+Tp*h:dt:samples/2*Tp+Tp*h;x=x+rect(t1,T1).*(cos(pi*t1/T1)).^2; end
    case 5
        for h=-samples/2:samples/2; t1=-samples/2*Tp+Tp*h:dt:samples/2*Tp+Tp*h;x=x+manchester(t1,T1); end
    case 6
        for h=-samples/2:samples/2; t1=-samples/2*Tp+Tp*h:dt:samples/2*Tp+Tp*h;x=x+raised_cosine(t1,T1,alpha); end
end
hold off
plot(t,x)
set(gca,'XLim',[-5,5])
set(gca,'YLim',[-2,2])
input('premere un tasto')
xf=fft(x);
xs=fftshift(xf);
df=1/dt/length(t);
f=-1/(2*dt)+df/2:df:1/(2*dt)-df/2;
plot(f,abs(xs)/max(abs(xs)),'r')
set(gca,'XLim',[-5,5])
switch(signal_type)
    case 1
        xt=T1*sinc(f*T1);
    case 2
        xt=T1/2*(sinc(f*T1/2)).^2;
    case 3
        xt=2*T1/pi*(cos(pi*f*T1))./(1-(2*f*T1).^2);
        xt(abs(f)==1/(2*T1))=T1/2;
    case 4
        xt=sin(pi*f*T1)./(1-(f*T1).^2)./(2*pi*f);
        xt(f==0)=T1/2;
        xt(abs(T1*f)==1)=T1/4;
    case 5
        xt=2*j*sin(pi*f*T1/2).*sinc(f*T1/2);
    case 6
        xt=zeros(1,length(f));
        xt(abs(f)<=(1-alpha)/(2*T1))=T1;
        xt(abs(f)>(1-alpha)/(2*T1)&abs(f)<=(1+alpha)/(2*T1))=T1/2*(1+cos(pi*T1/alpha*(abs(f(abs(f)>(1-alpha)/(2*T1)&abs(f)<=(1+alpha)/(2*T1)))-(1-alpha)/(2*T1))));
end
hold on
input('premere un tasto')
k=-100:100;
switch(signal_type)
    case 1
        c=T1/Tp*sinc(k/Tp*T1);
    case 2
        c=T1/(2*Tp)*(sinc(k*T1/(2*Tp))).^2;
    case 3
        c=2*T1/(Tp*pi)*(cos(pi*k/Tp*T1))./(1-(2*k/Tp*T1).^2);
        c(abs(k/Tp)==1/(2*T1))=T1/(Tp*2);
    case 4
        c=sin(pi*k*T1/Tp)./(1-(k*T1/Tp).^2)./(2*pi*k/Tp)/Tp;
        c(k==0)=T1/2/Tp;
        c(abs(T1*k/Tp)==1)=T1/4/Tp;
    case 5
        c=2*j*sin(pi*k*T1/(2*Tp)).*sinc(k*T1/(2*Tp))/Tp;
    case 6
        c=zeros(1,length(k));
        c(abs(k/Tp)<=(1-alpha)/(2*T1))=T1/Tp;
        c(abs(k)/Tp>(1-alpha)/(2*T1)&abs(k)/Tp<=(1+alpha)/(2*T1))=T1/(2*Tp)*(1+cos(pi*T1/alpha*(abs(k(abs(k/Tp)>(1-alpha)/(2*T1)&abs(k/Tp)<=(1+alpha)/(2*T1))/Tp)-(1-alpha)/(2*T1))));
        
end
plot(f,abs(xt)/max(abs(c))/Tp,'k')
input('premere un tasto')
stem(k/Tp,abs(c)/max(abs(c)),'ko')
sum(abs(c.^2))