%Esempio campionamento e influenza dei parametri
%le funzioni elementari esaminate hanno area unitaria
pulse=input('funzione: 0 rettangolo, 1 triangolo, 2 esponenziale, 3 sinc: ');
switch pulse
    case 0 
        T1=input('durata rettangolo: ')/2;
    case 1 
        T1=input('durata triangolo: ');
    case 2
        alfa=input('coefficiente esponenziale: ');
    case 3
        banda=input('banda: ')*2;
    otherwise
        disp('errore');
        return
end
Ts=input('intervallo di campionamento: ');
alfa=input('roll off (0-1): ');
if alfa < 0 || alfa > 1, disp('error'), return, end
Ts0=Ts/20; %campionamento pi fitto per il segnale circa tempo continuo
logplot=input('visualizzazione (1: in dB, 0: lineare): '); %plot modulo trasformata in dB
T0=input('valore massimo asse dei tempi: ');
expansion=20;
t=-expansion*T0:Ts0:T0*expansion; %asse temporale
len=length(t); %lunghezza asse temporale
x=zeros(1,length(t));
switch pulse
    case 0
        x=rect(t,T1); %segnale non a banda limitata rettangolo
    case 1
        x=triangle(t,T1); %Triangolo
    case 2
        x=exp(-alfa*abs(t))*(alfa/2);
    case 3
        x=sinc(t*banda)*banda;
end    
X=fft(x);
f=0:1/(Ts0*len):1/Ts0*(1-1/len);
%figure;
subplot(1,2,1);
if logplot==1
    plot(f(f<1/Ts/2),20*log10(abs(X(f<1/Ts/2))*Ts0),'k');
    set(gca,'YLim',[-40,5]);
else
    plot(f(f<1/Ts/2),abs(X(f<1/Ts/2))*Ts0,'k');
end
xlabel('f [Hz]');
hold on
title('Trasformata di Fourier: nero, Versione campionata: rosso');
ts=-T0:Ts:T0;
ls=length(ts);
xs=zeros(1,length(ts));
switch pulse
    case 0
        xs=rect(ts,T1); %segnale campionato
    case 1
        xs=triangle(ts,T1); %Triangolo
    case 2
        xs=exp(-alfa*abs(ts))*(alfa/2);  
    case 3
        xs=sinc(ts*banda)*banda;
end  
Xs=fft(xs);
fs=0:1/(Ts*ls):1/Ts*(1-1/ls);
if logplot==1
    plot(fs(fs<2/(2*Ts)/2),20*log10(abs(Xs(fs<2/(2*Ts)/2))*Ts),'ro:');
else
    plot(fs(fs<2/(2*Ts)/2),(abs(Xs(fs<2/(2*Ts)/2))*Ts),'ro:');
end
%figure;
expansion=1;
t1=-expansion*T0:Ts0:expansion*T0; %asse temporale esteso
len=length(t1); %lunghezza asse temporale
x1=zeros(1,length(t1));
switch pulse
    case 0
        x1=rect(t1,T1); %segnale non a banda limitata rettangolo
    case 1
        x1=triangle(t1,T1); %Triangolo
    case 2
        x1=exp(-alfa*abs(t1))*(alfa/2);  
    case 3
        x1=sinc(t1*banda)*banda;
end    
subplot(1,2,2);
plot(t1,x1,'k:');
xlabel('t [s]');
title('Segnale originale: nero, Segnale ricostruito: rosso (sampling) blu (raised cosine)');
set(gca,'Xlim', [t1(1),t1(length(t1))]);
hold on
xr=zeros(ls,len);
for i=1:ls, xr(i,:)=xs(i)*sinc(t1/Ts-i+(ls-1)/2+1); end
plot(t1,sum(xr),'r');
xr1=zeros(ls,len);
for i=1:ls, xr1(i,:)=xs(i)*RaisedCosine(t1/Ts-i+(ls-1)/2+1,alfa); end
plot(t1,sum(xr1),'b');